/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub;

import com.blackducksoftware.integration.log.IntLogger;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang3.StringUtils;

public class ScannerSplitStream
extends OutputStream {
    private static final int EOF = -1;
    private static final int ETX = 3;
    private static final int EOT = 4;
    private static final int LF = 10;
    private static final int CR = 13;
    private static final String EXCEPTION = "Exception:";
    private static final String FINISHED = "Finished in";
    private static final String ERROR = "ERROR:";
    private static final String WARN = "WARN:";
    private static final String INFO = "INFO:";
    private static final String DEBUG = "DEBUG:";
    private static final String TRACE = "TRACE:";
    private final OutputStream outputFileStream;
    private final IntLogger logger;
    private String output = "";
    private String lineBuffer = "";
    private String currentLine = "";
    private int previousCodePoint = -1;

    public ScannerSplitStream(IntLogger logger, OutputStream outputFileStream) {
        this.outputFileStream = outputFileStream;
        this.logger = logger;
    }

    public String getOutput() {
        return this.output;
    }

    public Boolean hasOutput() {
        return StringUtils.isNotBlank(this.output);
    }

    @Override
    public void write(int codePoint) throws IOException {
        this.outputFileStream.write(codePoint);
        if (-1 == codePoint) {
            throw new EOFException();
        }
        boolean atLineEnd = false;
        if (3 == codePoint || 4 == codePoint) {
            atLineEnd = true;
        } else if (10 == codePoint && 13 != this.previousCodePoint) {
            atLineEnd = true;
        } else if (10 == codePoint && 13 == this.previousCodePoint) {
            atLineEnd = true;
            this.currentLine = this.currentLine.substring(0, this.currentLine.length() - 1);
        } else if (10 != codePoint && 13 == this.previousCodePoint) {
            this.processLine(this.currentLine);
            this.currentLine = "";
        }
        this.previousCodePoint = codePoint;
        if (atLineEnd) {
            this.processLine(this.currentLine);
            this.currentLine = "";
        } else {
            String stringAscii = new String(Character.toChars(codePoint));
            this.currentLine = this.currentLine + stringAscii;
        }
    }

    private Boolean isLoggableLine(String line) {
        if (StringUtils.containsIgnoreCase(line, ERROR)) {
            return true;
        }
        if (StringUtils.containsIgnoreCase(line, WARN)) {
            return true;
        }
        if (StringUtils.containsIgnoreCase(line, INFO)) {
            return true;
        }
        if (StringUtils.containsIgnoreCase(line, DEBUG)) {
            return true;
        }
        if (StringUtils.containsIgnoreCase(line, TRACE)) {
            return true;
        }
        if (StringUtils.containsIgnoreCase(line, EXCEPTION)) {
            return true;
        }
        if (StringUtils.containsIgnoreCase(line, FINISHED)) {
            return true;
        }
        return false;
    }

    private void processLine(String line) throws UnsupportedEncodingException {
        if (this.lineBuffer.length() == 0) {
            this.lineBuffer = line;
        } else if (this.isLoggableLine(line).booleanValue()) {
            this.writeToConsole(this.lineBuffer);
            this.lineBuffer = line;
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append(this.lineBuffer);
            builder.append(System.getProperty("line.separator"));
            builder.append(line);
            this.lineBuffer = builder.toString();
        }
    }

    @Override
    public void write(byte[] byteArray) throws IOException {
        this.outputFileStream.write(byteArray);
        String currentLine = new String(byteArray, "UTF-8");
        if (currentLine.contains(System.getProperty("line.separator"))) {
            String[] splitLines;
            for (String line : splitLines = currentLine.split(System.getProperty("line.separator"))) {
                this.processLine(line);
            }
        } else {
            this.processLine(currentLine);
        }
    }

    @Override
    public void write(byte[] byteArray, int offset, int length) throws IOException {
        this.outputFileStream.write(byteArray, offset, length);
        String currentLine = new String(byteArray, offset, length, "UTF-8");
        if (currentLine.contains(System.getProperty("line.separator"))) {
            String[] splitLines;
            for (String line : splitLines = currentLine.split(System.getProperty("line.separator"))) {
                this.processLine(line);
            }
        } else {
            this.processLine(currentLine);
        }
    }

    @Override
    public void flush() throws IOException {
        this.outputFileStream.flush();
        this.writeToConsole(this.lineBuffer);
        this.lineBuffer = "";
        if (StringUtils.isNotBlank(this.currentLine)) {
            this.writeToConsole(this.currentLine);
            this.currentLine = "";
        }
    }

    @Override
    public void close() throws IOException {
        this.outputFileStream.close();
    }

    private void writeToConsole(String line) {
        if (StringUtils.containsIgnoreCase(line, DEBUG) || StringUtils.containsIgnoreCase(line, TRACE)) {
            return;
        }
        StringBuilder outputBuilder = new StringBuilder();
        outputBuilder.append(this.output);
        if (StringUtils.containsIgnoreCase(line, EXCEPTION)) {
            outputBuilder.append(line);
            outputBuilder.append(System.getProperty("line.separator"));
            this.logger.error(line);
        } else if (StringUtils.containsIgnoreCase(line, FINISHED)) {
            outputBuilder.append(line);
            outputBuilder.append(System.getProperty("line.separator"));
            this.logger.info(line);
        } else if (StringUtils.containsIgnoreCase(line, ERROR)) {
            outputBuilder.append(line);
            outputBuilder.append(System.getProperty("line.separator"));
            this.logger.error(line);
        } else if (StringUtils.containsIgnoreCase(line, WARN)) {
            outputBuilder.append(line);
            outputBuilder.append(System.getProperty("line.separator"));
            this.logger.warn(line);
        } else if (StringUtils.containsIgnoreCase(line, INFO)) {
            outputBuilder.append(line);
            outputBuilder.append(System.getProperty("line.separator"));
            this.logger.info(line);
        }
        this.output = outputBuilder.toString();
    }
}

