/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.api.report;

import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.RecursiveToStringStyle;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

public class LicenseDefinition {
    private final String licenseId;
    private final String discoveredAs;
    private final String name;
    private final String spdxId;
    private final String ownership;
    private final String codeSharing;
    private final String licenseDisplay;

    public LicenseDefinition(String licenseId, String discoveredAs, String name, String spdxId, String ownership, String codeSharing, String licenseDisplay) {
        this.licenseId = licenseId;
        this.discoveredAs = discoveredAs;
        this.name = name;
        this.spdxId = spdxId;
        this.ownership = ownership;
        this.codeSharing = codeSharing;
        this.licenseDisplay = licenseDisplay;
    }

    public String getLicenseId() {
        return this.licenseId;
    }

    public UUID getLicenseUUId() {
        if (StringUtils.isBlank(this.licenseId)) {
            return null;
        }
        try {
            return UUID.fromString(this.licenseId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String getDiscoveredAs() {
        return this.discoveredAs;
    }

    public String getName() {
        return this.name;
    }

    public String getSpdxId() {
        return this.spdxId;
    }

    public String getOwnership() {
        return this.ownership;
    }

    public String getCodeSharing() {
        return this.codeSharing;
    }

    public String getLicenseDisplay() {
        return this.licenseDisplay;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.codeSharing == null ? 0 : this.codeSharing.hashCode());
        result = 31 * result + (this.discoveredAs == null ? 0 : this.discoveredAs.hashCode());
        result = 31 * result + (this.licenseId == null ? 0 : this.licenseId.hashCode());
        result = 31 * result + (this.licenseDisplay == null ? 0 : this.licenseDisplay.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.ownership == null ? 0 : this.ownership.hashCode());
        result = 31 * result + (this.spdxId == null ? 0 : this.spdxId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseDefinition)) {
            return false;
        }
        LicenseDefinition other = (LicenseDefinition)obj;
        if (this.codeSharing == null ? other.codeSharing != null : !this.codeSharing.equals(other.codeSharing)) {
            return false;
        }
        if (this.discoveredAs == null ? other.discoveredAs != null : !this.discoveredAs.equals(other.discoveredAs)) {
            return false;
        }
        if (this.licenseId == null ? other.licenseId != null : !this.licenseId.equals(other.licenseId)) {
            return false;
        }
        if (this.licenseDisplay == null ? other.licenseDisplay != null : !this.licenseDisplay.equals(other.licenseDisplay)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.ownership == null ? other.ownership != null : !this.ownership.equals(other.ownership)) {
            return false;
        }
        return !(this.spdxId == null ? other.spdxId != null : !this.spdxId.equals(other.spdxId));
    }

    public String toString() {
        return ReflectionToStringBuilder.toString(this, RecursiveToStringStyle.JSON_STYLE);
    }
}

