/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.api.user;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.exception.DoesNotExistException;
import com.blackducksoftware.integration.hub.model.view.AssignedProjectView;
import com.blackducksoftware.integration.hub.model.view.RoleView;
import com.blackducksoftware.integration.hub.model.view.UserView;
import com.blackducksoftware.integration.hub.rest.RestConnection;
import com.blackducksoftware.integration.hub.service.HubService;
import java.util.List;

public class UserService
extends HubService {
    public UserService(RestConnection restConnection) {
        super(restConnection);
    }

    public List<UserView> getAllUsers() throws IntegrationException {
        List<UserView> allUserItems = this.getAllViewsFromApi("users", UserView.class);
        return allUserItems;
    }

    public UserView getUserByUserName(String userName) throws IntegrationException {
        List<UserView> allUsers = this.getAllUsers();
        for (UserView user : allUsers) {
            if (!user.userName.equalsIgnoreCase(userName)) continue;
            return user;
        }
        throw new DoesNotExistException("This User does not exist. UserName : " + userName);
    }

    public List<AssignedProjectView> getUserAssignedProjects(UserView userView) throws IntegrationException {
        List<AssignedProjectView> assignedProjectViews = this.getAllViewsFromLink(userView, "projects", AssignedProjectView.class);
        return assignedProjectViews;
    }

    public List<RoleView> getUserRoles(UserView userView) throws IntegrationException {
        List<RoleView> assignedRoles = this.getAllViewsFromLink(userView, "roles", RoleView.class);
        return assignedRoles;
    }
}

