/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.cli;

import com.blackducksoftware.integration.exception.EncryptionException;
import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.certificate.CertificateHandler;
import com.blackducksoftware.integration.hub.cli.CLILocation;
import com.blackducksoftware.integration.hub.exception.HubIntegrationException;
import com.blackducksoftware.integration.hub.rest.RestConnection;
import com.blackducksoftware.integration.log.IntLogger;
import com.blackducksoftware.integration.util.CIEnvironmentVariables;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.lang3.StringUtils;

public class CLIDownloadUtility {
    private final IntLogger logger;
    private final RestConnection restConnection;

    public CLIDownloadUtility(IntLogger logger, RestConnection restConnection) {
        this.logger = logger;
        this.restConnection = restConnection;
    }

    public void performInstallation(File directoryToInstallTo, CIEnvironmentVariables ciEnvironmentVariables, String hubUrl, String hubVersion, String localHostName) throws HubIntegrationException, EncryptionException {
        if (StringUtils.isBlank(localHostName)) {
            throw new IllegalArgumentException("You must provided the hostName of the machine this is running on.");
        }
        CLILocation cliLocation = new CLILocation(this.logger, directoryToInstallTo);
        String cliDownloadUrl = cliLocation.getCLIDownloadUrl(this.logger, hubUrl);
        if (StringUtils.isNotBlank(cliDownloadUrl)) {
            try {
                this.customInstall(cliLocation, ciEnvironmentVariables, new URL(cliDownloadUrl), hubVersion, localHostName);
            }
            catch (MalformedURLException e) {
                throw new HubIntegrationException(String.format("The cli could not be downloaded from %s: %s", cliDownloadUrl, e.getMessage()), e);
            }
        } else {
            this.logger.error("Could not find the correct Hub CLI download URL.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void customInstall(CLILocation cliLocation, CIEnvironmentVariables ciEnvironmentVariables, URL cliDownloadUrl, String hubVersion, String localHostName) throws HubIntegrationException, EncryptionException {
        String directoryToInstallTo;
        try {
            directoryToInstallTo = cliLocation.getCanonicalPath();
        }
        catch (IOException e) {
            throw new HubIntegrationException("Could not get the path for the install directory for the cli - does it exist?", e);
        }
        try {
            File cliInstallDirectory;
            boolean cliMismatch = true;
            File hubVersionFile = cliLocation.createHubVersionFile();
            if (hubVersionFile.exists()) {
                String storedHubVersion = IOUtils.toString((Reader)new FileReader(hubVersionFile));
                if (hubVersion.equals(storedHubVersion)) {
                    cliMismatch = false;
                } else {
                    hubVersionFile.delete();
                    hubVersionFile.createNewFile();
                }
            }
            if (!(cliInstallDirectory = cliLocation.getCLIInstallDir()).exists()) {
                cliMismatch = true;
            }
            if (cliMismatch) {
                this.logger.debug("Attempting to download the Hub CLI.");
                FileWriter writer = new FileWriter(hubVersionFile);
                writer.write(hubVersion);
                writer.close();
                hubVersionFile.setLastModified(0L);
            }
            long cliTimestamp = hubVersionFile.lastModified();
            Response response = null;
            InputStream cliStream = null;
            try {
                try {
                    HttpUrl httpUrl = this.restConnection.createHttpUrl(cliDownloadUrl);
                    HashMap<String, String> headers = new HashMap<String, String>();
                    headers.put("If-Modified-Since", String.valueOf(cliTimestamp));
                    File[] request = this.restConnection.createGetRequest(httpUrl, headers);
                    response = this.restConnection.handleExecuteClientCall((Request)request);
                }
                catch (IntegrationException e) {
                    this.logger.error("Skipping installation of " + cliDownloadUrl + " to " + directoryToInstallTo + ": " + e.toString());
                    if (cliStream != null) {
                        cliStream.close();
                    }
                    if (response != null) {
                        response.close();
                    }
                    return;
                }
                if (response.code() == 304) {
                    return;
                }
                String lastModified = response.header("Last-Modified");
                Long lastModifiedLong = 0L;
                if (StringUtils.isNotBlank(lastModified)) {
                    lastModifiedLong = Date.parse(lastModified);
                }
                if (cliInstallDirectory.exists() && cliInstallDirectory.listFiles().length > 0) {
                    if (!cliMismatch && lastModifiedLong == cliTimestamp) {
                        this.logger.debug("The current Hub CLI is up to date.");
                        return;
                    }
                    for (File file : cliInstallDirectory.listFiles()) {
                        FileUtils.deleteDirectory((File)file);
                    }
                } else {
                    cliInstallDirectory.mkdir();
                }
                this.logger.debug("Updating the Hub CLI.");
                hubVersionFile.setLastModified(lastModifiedLong);
                this.logger.info("Unpacking " + cliDownloadUrl.toString() + " to " + directoryToInstallTo + " on " + localHostName);
                ResponseBody responseBody = response.body();
                cliStream = responseBody.byteStream();
                try (CountingInputStream cis = new CountingInputStream(cliStream);){
                    this.unzip(cliInstallDirectory, (InputStream)cis, this.logger);
                    this.updateJreSecurity(this.logger, cliLocation, ciEnvironmentVariables);
                }
            }
            finally {
                if (cliStream != null) {
                    cliStream.close();
                }
                if (response != null) {
                    response.close();
                }
            }
        }
        catch (IOException e) {
            throw new HubIntegrationException("Failed to install " + cliDownloadUrl + " to " + directoryToInstallTo, e);
        }
    }

    private void updateJreSecurity(IntLogger logger, CLILocation cliLocation, CIEnvironmentVariables ciEnvironmentVariables) throws IOException {
        File securityDirectory = cliLocation.getJreSecurityDirectory();
        if (securityDirectory == null || !securityDirectory.isDirectory()) {
            logger.warn("CLI location : " + cliLocation.getCanonicalPath());
            logger.warn("Can not copy the trust store into the CLI JRE. Can not find the CLI JRE.");
            return;
        }
        File trustStoreFile = null;
        if (ciEnvironmentVariables.containsKey("BDS_CACERTS_OVERRIDE")) {
            logger.trace("Found the variable : BDS_CACERTS_OVERRIDE, using value : " + ciEnvironmentVariables.getValue("BDS_CACERTS_OVERRIDE"));
            String trustStorePath = ciEnvironmentVariables.getValue("BDS_CACERTS_OVERRIDE");
            trustStoreFile = new File(trustStorePath);
        } else {
            CertificateHandler certificateHandler = new CertificateHandler(logger);
            trustStoreFile = certificateHandler.getTrustStore();
        }
        logger.trace("Copying the trust store from : " + trustStoreFile.getAbsolutePath());
        String trustStoreFilename = trustStoreFile.getName();
        File trustStore = new File(securityDirectory, trustStoreFilename);
        File trustStoreBackup = new File(securityDirectory, trustStoreFilename + System.currentTimeMillis());
        try {
            if (trustStore.exists()) {
                FileUtils.moveFile((File)trustStore, (File)trustStoreBackup);
            }
            FileUtils.copyFile((File)trustStoreFile, (File)trustStore);
        }
        catch (IOException e) {
            logger.error("Could not copy the trust store file from: " + trustStoreFile.getAbsolutePath() + " to: " + trustStore.getAbsolutePath() + " msg: " + e.getMessage());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzip(File dir, InputStream in, IntLogger logger) throws IOException {
        File tmpFile = File.createTempFile("tmpzip", null);
        try {
            this.copyInputStreamToFile(in, tmpFile);
            this.unzip(dir, tmpFile, logger);
        }
        finally {
            tmpFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzip(File dir, File zipFile, IntLogger logger) throws IOException {
        dir = dir.getAbsoluteFile();
        ZipFile zip = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        try {
            while (entries.hasMoreElements()) {
                ZipEntry e = entries.nextElement();
                File f = new File(dir, e.getName());
                if (e.isDirectory()) {
                    f.mkdirs();
                    continue;
                }
                File p = f.getParentFile();
                if (p != null) {
                    p.mkdirs();
                }
                try (InputStream input = zip.getInputStream(e);){
                    this.copyInputStreamToFile(input, f);
                }
                f.setLastModified(e.getTime());
            }
        }
        finally {
            zip.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyInputStreamToFile(InputStream in, File f) throws IOException {
        FileOutputStream fos = new FileOutputStream(f);
        try {
            IOUtils.copy((InputStream)in, (OutputStream)fos);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)fos);
        }
    }
}

