/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.cli;

import com.blackducksoftware.integration.hub.exception.HubIntegrationException;
import com.blackducksoftware.integration.log.IntLogger;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class CLILocation {
    public static final String CLI_UNZIP_DIR = "Hub_Scan_Installation";
    public static final String VERSION_FILE_NAME = "hubVersion.txt";
    public static final String DEFAULT_CLI_DOWNLOAD = "scan.cli.zip";
    public static final String WINDOWS_CLI_DOWNLOAD = "scan.cli-windows.zip";
    public static final String MAC_CLI_DOWNLOAD = "scan.cli-macosx.zip";
    private final File directoryToInstallTo;
    private final IntLogger logger;

    public CLILocation(IntLogger logger, File directoryToInstallTo) {
        if (logger == null) {
            throw new IllegalArgumentException("You must provided a logger.");
        }
        if (directoryToInstallTo == null) {
            throw new IllegalArgumentException("You must provided a directory to install the CLI to.");
        }
        this.logger = logger;
        this.directoryToInstallTo = directoryToInstallTo;
    }

    public File getJreSecurityDirectory() throws IOException {
        File javaHome = this.getJavaHome();
        File jreSecurityDirectory = new File(javaHome, "lib");
        jreSecurityDirectory = new File(jreSecurityDirectory, "security");
        return jreSecurityDirectory;
    }

    public String getCLIDownloadUrl(IntLogger logger, String hubUrl) {
        if (SystemUtils.IS_OS_MAC_OSX) {
            return this.getCLIWrapperLink(hubUrl, MAC_CLI_DOWNLOAD);
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return this.getCLIWrapperLink(hubUrl, WINDOWS_CLI_DOWNLOAD);
        }
        return this.getCLIWrapperLink(hubUrl, DEFAULT_CLI_DOWNLOAD);
    }

    public File getOneJarFile() throws IOException {
        File cliHomeFile = this.getCLIHome();
        if (cliHomeFile == null) {
            this.logger.error("Could not find the CLI home directory");
            return null;
        }
        File oneJarFile = new File(cliHomeFile, "lib");
        oneJarFile = new File(oneJarFile, "cache");
        oneJarFile = new File(oneJarFile, "scan.cli.impl-standalone.jar");
        oneJarFile.setExecutable(true);
        return oneJarFile;
    }

    public File createHubVersionFile() throws HubIntegrationException, IOException {
        if (!this.directoryToInstallTo.exists() && !this.directoryToInstallTo.mkdirs()) {
            throw new HubIntegrationException("Could not create the directory : " + this.directoryToInstallTo.getCanonicalPath());
        }
        return new File(this.directoryToInstallTo, VERSION_FILE_NAME);
    }

    public File getCLIInstallDir() {
        return new File(this.directoryToInstallTo, CLI_UNZIP_DIR);
    }

    public String getCanonicalPath() throws IOException {
        return this.directoryToInstallTo.getCanonicalPath();
    }

    public File getCLIHome() throws IOException {
        File cliHome = this.getCLIInstallDir();
        if (cliHome == null) {
            this.logger.error("Could not find the CLI home directory");
            return null;
        }
        File[] installDirFiles = cliHome.listFiles();
        if (installDirFiles == null) {
            this.logger.error("Could not find the directories in the CLI home : " + cliHome.getCanonicalPath());
            return null;
        }
        if (installDirFiles.length > 1) {
            for (File currentFile : installDirFiles) {
                if (currentFile.getName().contains("windows") || currentFile.isHidden()) continue;
                return currentFile;
            }
            return null;
        }
        if (installDirFiles.length == 1) {
            return installDirFiles[0];
        }
        this.logger.error("Could not find any directories in the CLI home : " + cliHome.getCanonicalPath());
        return null;
    }

    public File getProvidedJavaExec() throws IOException {
        File javaHome = this.getJavaHome();
        File javaExec = new File(javaHome, "bin");
        javaExec = SystemUtils.IS_OS_WINDOWS ? new File(javaExec, "java.exe") : new File(javaExec, "java");
        if (!javaExec.exists()) {
            this.logger.error("The java executable does not exist at : " + javaExec.getCanonicalPath());
            return null;
        }
        javaExec.setExecutable(true);
        return javaExec;
    }

    public File getJavaHome() throws IOException {
        File cliHomeFile = this.getCLIHome();
        if (cliHomeFile == null) {
            this.logger.error("Could not find the CLI home directory");
            return null;
        }
        File[] files = cliHomeFile.listFiles();
        File jreFolder = this.findFileByName(files, "jre");
        if (jreFolder == null) {
            this.logger.error("Could not find the JRE directory in : " + cliHomeFile.getCanonicalPath());
            return null;
        }
        File javaHome = this.getJreContentsDirectory(jreFolder);
        return javaHome;
    }

    public boolean getCLIExists(IntLogger logger) throws IOException {
        File cli = this.getCLI(logger);
        return cli != null && cli.exists();
    }

    public File getCLI(IntLogger logger) throws IOException {
        File cliHomeFile = this.getCLIHome();
        if (cliHomeFile == null) {
            logger.error("Could not find the CLI home directory");
            return null;
        }
        logger.debug("BlackDuck scan directory: " + cliHomeFile.getCanonicalPath());
        File[] files = cliHomeFile.listFiles();
        if (files == null || files.length <= 0) {
            logger.error("No files found in the BlackDuck scan directory.");
            return null;
        }
        logger.debug("directories in the BlackDuck scan directory: " + files.length);
        File libFolder = this.findFileByName(files, "lib");
        if (libFolder == null) {
            logger.error("Could not find the lib directory of the CLI.");
            return null;
        }
        logger.debug("BlackDuck scan lib directory: " + libFolder.getCanonicalPath());
        File hubScanJar = null;
        for (File file : libFolder.listFiles()) {
            if (!file.getName().startsWith("scan.cli") || !file.getName().endsWith(".jar")) continue;
            hubScanJar = file;
            hubScanJar.setExecutable(true);
            break;
        }
        return hubScanJar;
    }

    private File getJreContentsDirectory(File jreFolder) {
        File jreContents = jreFolder;
        List<String> filenames = Arrays.asList(jreContents.list());
        if (filenames.contains("Contents")) {
            jreContents = new File(jreContents, "Contents");
            jreContents = new File(jreContents, "Home");
        }
        return jreContents;
    }

    private File findFileByName(File[] files, String name) {
        if (files != null && files.length > 0) {
            for (File file : files) {
                if (!name.equalsIgnoreCase(file.getName())) continue;
                return file;
            }
        }
        return null;
    }

    private String getCLIWrapperLink(String hubUrl, String downloadFilename) {
        if (StringUtils.isBlank(hubUrl)) {
            throw new IllegalArgumentException("You must provide a valid Hub URL in order to get the correct link.");
        }
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(hubUrl);
        if (!hubUrl.endsWith("/")) {
            urlBuilder.append("/");
        }
        urlBuilder.append("download");
        urlBuilder.append("/");
        urlBuilder.append(downloadFilename);
        return urlBuilder.toString();
    }

    public File getDirectoryToInstallTo() {
        return this.directoryToInstallTo;
    }
}

