/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.dataservice.scan;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.api.codelocation.CodeLocationService;
import com.blackducksoftware.integration.hub.api.project.ProjectService;
import com.blackducksoftware.integration.hub.api.project.version.ProjectVersionService;
import com.blackducksoftware.integration.hub.api.scan.ScanSummaryService;
import com.blackducksoftware.integration.hub.api.view.MetaHandler;
import com.blackducksoftware.integration.hub.exception.HubIntegrationException;
import com.blackducksoftware.integration.hub.exception.HubTimeoutExceededException;
import com.blackducksoftware.integration.hub.model.enumeration.CodeLocationEnum;
import com.blackducksoftware.integration.hub.model.enumeration.ScanSummaryStatusEnum;
import com.blackducksoftware.integration.hub.model.view.CodeLocationView;
import com.blackducksoftware.integration.hub.model.view.ProjectVersionView;
import com.blackducksoftware.integration.hub.model.view.ProjectView;
import com.blackducksoftware.integration.hub.model.view.ScanSummaryView;
import com.blackducksoftware.integration.log.IntLogger;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class ScanStatusDataService {
    public static final long FIVE_SECONDS = 5000L;
    public static final long DEFAULT_TIMEOUT = 300000L;
    private final IntLogger logger;
    private final ProjectService projectRequestService;
    private final ProjectVersionService projectVersionRequestService;
    private final CodeLocationService codeLocationRequestService;
    private final ScanSummaryService scanSummaryRequestService;
    private final MetaHandler metaService;
    private final long timeoutInMilliseconds;
    private static final Set<ScanSummaryStatusEnum> PENDING_STATES = EnumSet.of(ScanSummaryStatusEnum.UNSTARTED, new ScanSummaryStatusEnum[]{ScanSummaryStatusEnum.SCANNING, ScanSummaryStatusEnum.SAVING_SCAN_DATA, ScanSummaryStatusEnum.SCAN_DATA_SAVE_COMPLETE, ScanSummaryStatusEnum.REQUESTED_MATCH_JOB, ScanSummaryStatusEnum.MATCHING, ScanSummaryStatusEnum.BOM_VERSION_CHECK, ScanSummaryStatusEnum.BUILDING_BOM});
    private static final Set<ScanSummaryStatusEnum> DONE_STATES = EnumSet.of(ScanSummaryStatusEnum.COMPLETE, new ScanSummaryStatusEnum[]{ScanSummaryStatusEnum.CANCELLED, ScanSummaryStatusEnum.CLONED, ScanSummaryStatusEnum.ERROR_SCANNING, ScanSummaryStatusEnum.ERROR_SAVING_SCAN_DATA, ScanSummaryStatusEnum.ERROR_MATCHING, ScanSummaryStatusEnum.ERROR_BUILDING_BOM, ScanSummaryStatusEnum.ERROR});
    private static final Set<ScanSummaryStatusEnum> ERROR_STATES = EnumSet.of(ScanSummaryStatusEnum.CANCELLED, new ScanSummaryStatusEnum[]{ScanSummaryStatusEnum.ERROR_SCANNING, ScanSummaryStatusEnum.ERROR_SAVING_SCAN_DATA, ScanSummaryStatusEnum.ERROR_MATCHING, ScanSummaryStatusEnum.ERROR_BUILDING_BOM, ScanSummaryStatusEnum.ERROR});

    public ScanStatusDataService(IntLogger logger, ProjectService projectRequestService, ProjectVersionService projectVersionRequestService, CodeLocationService codeLocationRequestService, ScanSummaryService scanSummaryRequestService, long timeoutInMilliseconds) {
        this.logger = logger;
        this.metaService = new MetaHandler(logger);
        this.projectRequestService = projectRequestService;
        this.projectVersionRequestService = projectVersionRequestService;
        this.codeLocationRequestService = codeLocationRequestService;
        this.scanSummaryRequestService = scanSummaryRequestService;
        long timeout = timeoutInMilliseconds;
        if (timeoutInMilliseconds <= 0L) {
            timeout = 300000L;
            logger.alwaysLog(timeoutInMilliseconds + "ms is not a valid BOM wait time, using : " + timeout + "ms instead");
        }
        this.timeoutInMilliseconds = timeout;
    }

    public void assertBomImportScanStartedThenFinished(String projectName, String projectVersion) throws HubTimeoutExceededException, IntegrationException {
        List<ScanSummaryView> pendingScans = this.waitForPendingScansToStart(projectName, projectVersion, this.timeoutInMilliseconds);
        this.waitForScansToComplete(pendingScans, this.timeoutInMilliseconds);
    }

    public void assertCodeLocationFinished(String codeLocationName) throws HubTimeoutExceededException, IntegrationException {
        ArrayList<ScanSummaryView> pendingScans = new ArrayList<ScanSummaryView>();
        boolean foundPendingScan = false;
        long startedTime = System.currentTimeMillis();
        String timeoutMessage = "No pending code locations found within the specified wait time: %d minutes";
        while (!this.done(foundPendingScan, this.timeoutInMilliseconds, startedTime, "No pending code locations found within the specified wait time: %d minutes")) {
            try {
                CodeLocationView codeLocation = this.codeLocationRequestService.getCodeLocationByName(codeLocationName);
                String scanSummariesLink = this.metaService.getFirstLinkSafely(codeLocation, "scans");
                if (StringUtils.isNotBlank(scanSummariesLink)) {
                    ScanSummaryView scanSummaryView = this.scanSummaryRequestService.getView(scanSummariesLink, ScanSummaryView.class);
                    if (this.isPending(scanSummaryView.status)) {
                        pendingScans.add(scanSummaryView);
                    }
                }
                foundPendingScan = pendingScans.size() > 0;
            }
            catch (IntegrationException e) {
                this.logger.debug("Could not find a pending code location: " + e.getMessage());
            }
        }
    }

    public void assertScansFinished(List<ScanSummaryView> pendingScans) throws HubTimeoutExceededException, IntegrationException {
        this.waitForScansToComplete(pendingScans, this.timeoutInMilliseconds);
    }

    public void assertScansFinished(String projectName, String projectVersion) throws IntegrationException {
        ProjectView projectItem = this.projectRequestService.getProjectByName(projectName);
        ProjectVersionView projectVersionView = this.projectVersionRequestService.getProjectVersion(projectItem, projectVersion);
        this.assertScansFinished(projectVersionView);
    }

    public void assertScansFinished(ProjectVersionView projectVersionView) throws HubTimeoutExceededException, IntegrationException {
        List<CodeLocationView> allCodeLocations = this.codeLocationRequestService.getAllCodeLocationsForProjectVersion(projectVersionView);
        ArrayList<ScanSummaryView> scanSummaryViews = new ArrayList<ScanSummaryView>();
        for (CodeLocationView codeLocationView : allCodeLocations) {
            String scansLink = this.metaService.getFirstLinkSafely(codeLocationView, "scans");
            List<ScanSummaryView> codeLocationScanSummaryViews = this.scanSummaryRequestService.getAllScanSummaryItems(scansLink);
            scanSummaryViews.addAll(codeLocationScanSummaryViews);
        }
        this.assertScansFinished(scanSummaryViews);
    }

    private List<ScanSummaryView> waitForPendingScansToStart(String projectName, String projectVersion, long scanStartedTimeoutInMilliseconds) throws HubIntegrationException {
        List<ScanSummaryView> pendingScans = this.getPendingScans(projectName, projectVersion);
        long startedTime = System.currentTimeMillis();
        boolean pendingScansOk = pendingScans.size() > 0;
        String timeoutMessage = "No scan has started within the specified wait time: %d minutes";
        while (!this.done(pendingScansOk, scanStartedTimeoutInMilliseconds, startedTime, "No scan has started within the specified wait time: %d minutes")) {
            this.sleep("The thread waiting for the scan to start was interrupted: ", "Still waiting for the pending scans to start.");
            pendingScans = this.getPendingScans(projectName, projectVersion);
            pendingScansOk = pendingScans.size() > 0;
        }
        return pendingScans;
    }

    private void waitForScansToComplete(List<ScanSummaryView> pendingScans, long scanStartedTimeoutInMilliseconds) throws HubTimeoutExceededException, IntegrationException {
        pendingScans = this.getPendingScans(pendingScans);
        long startedTime = System.currentTimeMillis();
        boolean pendingScansOk = pendingScans.isEmpty();
        String timeoutMessage = "The pending scans have not completed within the specified wait time: %d minutes";
        while (!this.done(pendingScansOk, scanStartedTimeoutInMilliseconds, startedTime, "The pending scans have not completed within the specified wait time: %d minutes")) {
            this.sleep("The thread waiting for the scan to complete was interrupted: ", "Still waiting for the pending scans to complete.");
            pendingScans = this.getPendingScans(pendingScans);
            pendingScansOk = pendingScans.isEmpty();
        }
    }

    private void sleep(String interruptedMessage, String ongoingMessage) throws HubIntegrationException {
        try {
            this.logger.info(ongoingMessage);
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            throw new HubIntegrationException(interruptedMessage + e.getMessage(), e);
        }
    }

    private boolean done(boolean conditionToCheck, long timeoutInMilliseconds, long startedTime, String timeoutMessage) throws HubTimeoutExceededException {
        if (conditionToCheck) {
            return true;
        }
        if (this.takenTooLong(timeoutInMilliseconds, startedTime)) {
            throw new HubTimeoutExceededException(String.format(timeoutMessage, TimeUnit.MILLISECONDS.toMinutes(timeoutInMilliseconds)));
        }
        return false;
    }

    private boolean takenTooLong(long timeoutInMilliseconds, long startedTime) {
        long elapsed = System.currentTimeMillis() - startedTime;
        return elapsed > timeoutInMilliseconds;
    }

    private List<ScanSummaryView> getPendingScans(String projectName, String projectVersion) {
        ArrayList<ScanSummaryView> pendingScans = new ArrayList<ScanSummaryView>();
        try {
            ProjectView projectItem = this.projectRequestService.getProjectByName(projectName);
            ProjectVersionView projectVersionItem = this.projectVersionRequestService.getProjectVersion(projectItem, projectVersion);
            String projectVersionUrl = this.metaService.getHref(projectVersionItem);
            List<CodeLocationView> allCodeLocations = this.codeLocationRequestService.getAllCodeLocationsForCodeLocationType(CodeLocationEnum.BOM_IMPORT);
            ArrayList<String> allScanSummariesLinks = new ArrayList<String>();
            for (CodeLocationView codeLocationItem : allCodeLocations) {
                this.logger.debug("Checking codeLocation: " + codeLocationItem.name);
                String mappedProjectVersionUrl = codeLocationItem.mappedProjectVersion;
                if (!projectVersionUrl.equals(mappedProjectVersionUrl)) continue;
                String scanSummariesLink = this.metaService.getFirstLink(codeLocationItem, "scans");
                allScanSummariesLinks.add(scanSummariesLink);
            }
            ArrayList<ScanSummaryView> allScanSummaries = new ArrayList<ScanSummaryView>();
            for (String scanSummaryLink : allScanSummariesLinks) {
                allScanSummaries.addAll(this.scanSummaryRequestService.getAllScanSummaryItems(scanSummaryLink));
            }
            pendingScans = new ArrayList();
            for (ScanSummaryView scanSummaryItem : allScanSummaries) {
                if (!this.isPending(scanSummaryItem.status)) continue;
                this.logger.debug("Adding pending scan: " + scanSummaryItem.json);
                pendingScans.add(scanSummaryItem);
            }
        }
        catch (Exception e) {
            pendingScans = new ArrayList();
            this.logger.debug("Not able to get pending scans: " + e.getMessage());
        }
        return pendingScans;
    }

    private List<ScanSummaryView> getPendingScans(List<ScanSummaryView> scanSummaries) throws IntegrationException {
        ArrayList<ScanSummaryView> pendingScans = new ArrayList<ScanSummaryView>();
        for (ScanSummaryView scanSummaryItem : scanSummaries) {
            String scanSummaryLink = this.metaService.getHref(scanSummaryItem);
            ScanSummaryView currentScanSummaryItem = this.scanSummaryRequestService.getView(scanSummaryLink, ScanSummaryView.class);
            if (this.isPending(currentScanSummaryItem.status)) {
                pendingScans.add(currentScanSummaryItem);
                continue;
            }
            if (!this.isError(currentScanSummaryItem.status)) continue;
            throw new HubIntegrationException("There was a problem in the Hub processing the scan(s). Error Status : " + currentScanSummaryItem.status.toString() + ", " + currentScanSummaryItem.statusMessage);
        }
        return pendingScans;
    }

    public boolean isPending(ScanSummaryStatusEnum statusEnum) {
        return PENDING_STATES.contains((Object)statusEnum);
    }

    public boolean isDone(ScanSummaryStatusEnum statusEnum) {
        return DONE_STATES.contains((Object)statusEnum);
    }

    public boolean isError(ScanSummaryStatusEnum statusEnum) {
        return ERROR_STATES.contains((Object)statusEnum);
    }
}

