/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.dataservice.user;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.api.project.ProjectService;
import com.blackducksoftware.integration.hub.api.user.UserService;
import com.blackducksoftware.integration.hub.model.view.AssignedProjectView;
import com.blackducksoftware.integration.hub.model.view.ProjectView;
import com.blackducksoftware.integration.hub.model.view.RoleView;
import com.blackducksoftware.integration.hub.model.view.UserView;
import com.blackducksoftware.integration.log.IntLogger;
import java.util.ArrayList;
import java.util.List;

public class UserDataService {
    private final IntLogger logger;
    private final UserService userRequestService;
    private final ProjectService projectRequestService;

    public UserDataService(IntLogger logger, ProjectService projectRequestService, UserService userRequestService) {
        this.logger = logger;
        this.projectRequestService = projectRequestService;
        this.userRequestService = userRequestService;
    }

    public List<ProjectView> getProjectsForUser(String userName) throws IntegrationException {
        UserView user = this.userRequestService.getUserByUserName(userName);
        return this.getProjectsForUser(user);
    }

    public List<ProjectView> getProjectsForUser(UserView userView) throws IntegrationException {
        this.logger.debug("Attempting to get the assigned projects for User: " + userView.userName);
        List<AssignedProjectView> assignedProjectViews = this.userRequestService.getUserAssignedProjects(userView);
        ArrayList<ProjectView> resolvedProjectViews = new ArrayList<ProjectView>();
        for (AssignedProjectView assigned : assignedProjectViews) {
            ProjectView project = this.projectRequestService.getView(assigned.projectUrl, ProjectView.class);
            if (project == null) continue;
            resolvedProjectViews.add(project);
        }
        return resolvedProjectViews;
    }

    public List<RoleView> getRolesForUser(String userName) throws IntegrationException {
        UserView user = this.userRequestService.getUserByUserName(userName);
        return this.getRolesForUser(user);
    }

    public List<RoleView> getRolesForUser(UserView userView) throws IntegrationException {
        return this.userRequestService.getUserRoles(userView);
    }
}

