/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.proxy;

import java.io.IOException;
import java.net.Proxy;
import java.util.List;
import okhttp3.Authenticator;
import okhttp3.Challenge;
import okhttp3.Credentials;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

public class OkAuthenticator
implements Authenticator {
    public static final String PROXY_AUTH = "Proxy-Authenticate";
    public static final String PROXY_AUTH_RESP = "Proxy-Authorization";
    public static final String WWW_AUTH = "WWW-Authenticate";
    public static final String WWW_AUTH_RESP = "Authorization";
    private final String username;
    private final String password;
    private boolean proxy;
    private boolean basicAuth;

    public OkAuthenticator(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public Request authenticate(Route route, Response response) throws IOException {
        if (route.proxy() != null && route.proxy() != Proxy.NO_PROXY) {
            this.proxy = true;
        }
        this.checkAuthScheme(response);
        if (this.basicAuth) {
            if (response.priorResponse() != null) {
                return null;
            }
            return this.authenticateBasic(response);
        }
        return null;
    }

    private void checkAuthScheme(Response response) {
        List<Challenge> challenges = response.challenges();
        for (Challenge challenge : challenges) {
            if (!"Basic".equalsIgnoreCase(challenge.scheme())) continue;
            this.basicAuth = true;
        }
    }

    private Request authenticateBasic(Response response) throws IOException {
        String headerKey = this.proxy ? PROXY_AUTH_RESP : WWW_AUTH_RESP;
        String credential = Credentials.basic(this.username, this.password);
        return response.request().newBuilder().header(headerKey, credential).build();
    }
}

