/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.proxy;

import com.blackducksoftware.integration.builder.AbstractBuilder;
import com.blackducksoftware.integration.hub.Credentials;
import com.blackducksoftware.integration.hub.CredentialsBuilder;
import com.blackducksoftware.integration.hub.proxy.ProxyInfo;
import com.blackducksoftware.integration.hub.validator.ProxyInfoValidator;
import com.blackducksoftware.integration.validator.AbstractValidator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ProxyInfoBuilder
extends AbstractBuilder<ProxyInfo> {
    private String host;
    private String port;
    private String username;
    private String password;
    private int passwordLength;
    private String ignoredProxyHosts;

    @Override
    public ProxyInfo buildObject() throws IllegalArgumentException {
        ProxyInfo proxyInfo = null;
        int proxyPort = NumberUtils.toInt(this.port);
        if (StringUtils.isNotBlank(this.password) && StringUtils.isNotBlank(this.username)) {
            CredentialsBuilder credBuilder = new CredentialsBuilder();
            credBuilder.setUsername(this.username);
            credBuilder.setPassword(this.password);
            credBuilder.setPasswordLength(this.passwordLength);
            Credentials credResult = (Credentials)credBuilder.build();
            proxyInfo = new ProxyInfo(this.host, proxyPort, credResult, this.ignoredProxyHosts);
        } else {
            proxyInfo = new ProxyInfo(this.host, proxyPort, null, this.ignoredProxyHosts);
        }
        return proxyInfo;
    }

    @Override
    public AbstractValidator createValidator() {
        ProxyInfoValidator validator = new ProxyInfoValidator();
        validator.setHost(this.getHost());
        validator.setPort(this.getPort());
        validator.setUsername(this.getUsername());
        validator.setPassword(this.getPassword());
        validator.setPasswordLength(this.getPasswordLength());
        validator.setIgnoredProxyHosts(this.getIgnoredProxyHosts());
        return validator;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.setPort(String.valueOf(port));
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPasswordLength() {
        return this.passwordLength;
    }

    public void setPasswordLength(int passwordLength) {
        this.passwordLength = passwordLength;
    }

    public String getIgnoredProxyHosts() {
        return this.ignoredProxyHosts;
    }

    public void setIgnoredProxyHosts(String ignoredProxyHosts) {
        this.ignoredProxyHosts = ignoredProxyHosts;
    }

    public boolean hasProxySettings() {
        return StringUtils.isNotBlank(this.host) || StringUtils.isNotBlank(this.port) || StringUtils.isNotBlank(this.username) || StringUtils.isNotBlank(this.password) || StringUtils.isNotBlank(this.ignoredProxyHosts);
    }
}

