/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.request.builder;

import com.blackducksoftware.integration.builder.AbstractBuilder;
import com.blackducksoftware.integration.hub.model.enumeration.ProjectVersionDistributionEnum;
import com.blackducksoftware.integration.hub.model.enumeration.ProjectVersionPhaseEnum;
import com.blackducksoftware.integration.hub.model.request.ProjectRequest;
import com.blackducksoftware.integration.hub.model.request.ProjectVersionRequest;
import com.blackducksoftware.integration.hub.request.validator.ProjectRequestValidator;
import com.blackducksoftware.integration.validator.AbstractValidator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.commons.lang3.StringUtils;

public class ProjectRequestBuilder
extends AbstractBuilder<ProjectRequest> {
    private String projectName;
    private String description;
    private Boolean projectLevelAdjustments;
    private String projectOwner;
    private Integer projectTier;
    private String distribution = ProjectVersionDistributionEnum.EXTERNAL.name();
    private String phase = ProjectVersionPhaseEnum.DEVELOPMENT.name();
    private String versionName;
    private String versionNickname;
    private String releaseComments;
    private String releasedOn;

    @Override
    public AbstractValidator createValidator() {
        ProjectRequestValidator validator = new ProjectRequestValidator();
        validator.setProjectName(this.projectName);
        validator.setDescription(this.description);
        validator.setProjectLevelAdjustments(this.projectLevelAdjustments);
        validator.setProjectOwner(this.projectOwner);
        validator.setProjectTier(this.projectTier);
        validator.setDistribution(this.distribution);
        validator.setPhase(this.phase);
        validator.setVersionName(this.versionName);
        validator.setVersionNickname(this.versionNickname);
        validator.setReleaseComments(this.releaseComments);
        validator.setReleasedOn(this.releasedOn);
        return validator;
    }

    @Override
    public ProjectRequest buildObject() {
        ProjectVersionDistributionEnum distributionValue = ProjectVersionDistributionEnum.valueOf(this.distribution.toUpperCase());
        ProjectVersionPhaseEnum phaseValue = ProjectVersionPhaseEnum.valueOf(this.phase.toUpperCase());
        ProjectVersionRequest projectVersionRequest = new ProjectVersionRequest(distributionValue, phaseValue, this.versionName);
        projectVersionRequest.setReleaseComments(this.releaseComments);
        if (StringUtils.isNotBlank(this.releasedOn)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
            try {
                projectVersionRequest.setReleasedOn(sdf.parse(this.releasedOn));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        projectVersionRequest.setNickname(this.versionNickname);
        ProjectRequest projectRequest = new ProjectRequest(this.projectName);
        projectRequest.setDescription(this.description);
        projectRequest.setProjectLevelAdjustments(this.projectLevelAdjustments);
        projectRequest.setProjectOwner(this.projectOwner);
        projectRequest.setProjectTier(this.projectTier);
        projectRequest.setVersionRequest(projectVersionRequest);
        return projectRequest;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setProjectLevelAdjustments(Boolean projectLevelAdjustments) {
        this.projectLevelAdjustments = projectLevelAdjustments;
    }

    public void setProjectOwner(String projectOwner) {
        this.projectOwner = projectOwner;
    }

    public void setProjectTier(Integer projectTier) {
        this.projectTier = projectTier;
    }

    public void setDistribution(String distribution) {
        this.distribution = distribution;
    }

    public void setDistribution(ProjectVersionDistributionEnum distribution) {
        this.distribution = distribution.name();
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public void setPhase(ProjectVersionPhaseEnum phase) {
        this.phase = phase.name();
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public void setVersionNickname(String versionNickname) {
        this.versionNickname = versionNickname;
    }

    public void setReleaseComments(String releaseComments) {
        this.releaseComments = releaseComments;
    }

    public void setReleasedOn(String releasedOn) {
        this.releasedOn = releasedOn;
    }
}

