/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.rest.oauth;

import com.blackducksoftware.integration.hub.proxy.ProxyInfo;
import com.blackducksoftware.integration.hub.rest.AbstractRestConnectionBuilder;
import com.blackducksoftware.integration.hub.rest.oauth.AccessType;
import com.blackducksoftware.integration.hub.rest.oauth.OAuthRestConnection;
import com.blackducksoftware.integration.hub.rest.oauth.TokenManager;
import com.blackducksoftware.integration.hub.validator.OauthRestConnectionValidator;
import com.blackducksoftware.integration.validator.AbstractValidator;

public class OAuthRestConnectionBuilder
extends AbstractRestConnectionBuilder<OAuthRestConnection> {
    private TokenManager tokenManager;
    private AccessType accessType;

    public TokenManager getTokenManager() {
        return this.tokenManager;
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    public void setTokenManager(TokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public void setAccessType(AccessType accessType) {
        this.accessType = accessType;
    }

    @Override
    public void applyProxyInfo(ProxyInfo proxyInfo) {
        super.applyProxyInfo(proxyInfo);
        if (this.tokenManager != null) {
            this.tokenManager.setProxyInfo(proxyInfo);
        }
    }

    @Override
    public AbstractValidator createValidator() {
        OauthRestConnectionValidator validator = new OauthRestConnectionValidator();
        validator.setBaseUrl(this.getBaseUrl());
        validator.setTimeout(this.getTimeout());
        validator.setProxyHost(this.getProxyHost());
        validator.setProxyPort(this.getProxyPort());
        validator.setProxyUsername(this.getProxyUsername());
        validator.setProxyPassword(this.getProxyPassword());
        validator.setProxyIgnoreHosts(this.getProxyIgnoreHosts());
        validator.setLogger(this.getLogger());
        validator.setCommonRequestHeaders(this.getCommonRequestHeaders());
        validator.setAccessType(this.getAccessType());
        validator.setTokenManager(this.getTokenManager());
        return validator;
    }

    @Override
    public OAuthRestConnection createConnection(ProxyInfo proxyInfo) {
        return new OAuthRestConnection(this.getLogger(), this.getBaseConnectionUrl(), this.getTimeout(), this.tokenManager, this.accessType, proxyInfo);
    }
}

