/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.service;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.HubSupportHelper;
import com.blackducksoftware.integration.hub.api.aggregate.bom.AggregateBomService;
import com.blackducksoftware.integration.hub.api.bom.BomComponentIssueService;
import com.blackducksoftware.integration.hub.api.bom.BomImportService;
import com.blackducksoftware.integration.hub.api.codelocation.CodeLocationService;
import com.blackducksoftware.integration.hub.api.component.ComponentService;
import com.blackducksoftware.integration.hub.api.extension.ExtensionConfigService;
import com.blackducksoftware.integration.hub.api.extension.ExtensionUserOptionService;
import com.blackducksoftware.integration.hub.api.group.GroupService;
import com.blackducksoftware.integration.hub.api.license.LicenseService;
import com.blackducksoftware.integration.hub.api.matchedfiles.MatchedFilesService;
import com.blackducksoftware.integration.hub.api.nonpublic.HubRegistrationService;
import com.blackducksoftware.integration.hub.api.nonpublic.HubVersionService;
import com.blackducksoftware.integration.hub.api.notification.NotificationService;
import com.blackducksoftware.integration.hub.api.policy.PolicyService;
import com.blackducksoftware.integration.hub.api.project.ProjectAssignmentService;
import com.blackducksoftware.integration.hub.api.project.ProjectService;
import com.blackducksoftware.integration.hub.api.project.version.ProjectVersionService;
import com.blackducksoftware.integration.hub.api.report.ReportService;
import com.blackducksoftware.integration.hub.api.scan.DryRunUploadService;
import com.blackducksoftware.integration.hub.api.scan.ScanSummaryService;
import com.blackducksoftware.integration.hub.api.user.UserService;
import com.blackducksoftware.integration.hub.api.vulnerability.VulnerabilityService;
import com.blackducksoftware.integration.hub.api.vulnerablebomcomponent.VulnerableBomComponentService;
import com.blackducksoftware.integration.hub.cli.CLIDownloadUtility;
import com.blackducksoftware.integration.hub.cli.SimpleScanUtility;
import com.blackducksoftware.integration.hub.dataservice.cli.CLIDataService;
import com.blackducksoftware.integration.hub.dataservice.component.ComponentDataService;
import com.blackducksoftware.integration.hub.dataservice.extension.ExtensionConfigDataService;
import com.blackducksoftware.integration.hub.dataservice.license.LicenseDataService;
import com.blackducksoftware.integration.hub.dataservice.notification.NotificationDataService;
import com.blackducksoftware.integration.hub.dataservice.notification.model.PolicyNotificationFilter;
import com.blackducksoftware.integration.hub.dataservice.phonehome.PhoneHomeDataService;
import com.blackducksoftware.integration.hub.dataservice.policystatus.PolicyStatusDataService;
import com.blackducksoftware.integration.hub.dataservice.project.ProjectDataService;
import com.blackducksoftware.integration.hub.dataservice.report.RiskReportDataService;
import com.blackducksoftware.integration.hub.dataservice.scan.ScanStatusDataService;
import com.blackducksoftware.integration.hub.dataservice.user.UserDataService;
import com.blackducksoftware.integration.hub.dataservice.vulnerability.VulnerabilityDataService;
import com.blackducksoftware.integration.hub.global.HubServerConfig;
import com.blackducksoftware.integration.hub.rest.RestConnection;
import com.blackducksoftware.integration.hub.scan.HubScanConfig;
import com.blackducksoftware.integration.hub.service.HubService;
import com.blackducksoftware.integration.phonehome.PhoneHomeClient;
import com.blackducksoftware.integration.util.CIEnvironmentVariables;
import com.blackducksoftware.integration.util.IntegrationEscapeUtil;
import java.util.Map;
import org.apache.commons.lang3.builder.RecursiveToStringStyle;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

public class HubServicesFactory {
    private final CIEnvironmentVariables ciEnvironmentVariables = new CIEnvironmentVariables();
    private final RestConnection restConnection;

    public HubServicesFactory(RestConnection restConnection) {
        this.ciEnvironmentVariables.putAll(System.getenv());
        this.restConnection = restConnection;
    }

    public void addEnvironmentVariable(String key, String value) {
        this.ciEnvironmentVariables.put(key, value);
    }

    public void addEnvironmentVariables(Map<String, String> environmentVariables) {
        this.ciEnvironmentVariables.putAll(environmentVariables);
    }

    public CLIDataService createCLIDataService() {
        return this.createCLIDataService(120000L);
    }

    public CLIDataService createCLIDataService(long timeoutInMilliseconds) {
        return new CLIDataService(this.restConnection.logger, this.restConnection.gson, this.ciEnvironmentVariables, this.createHubVersionService(), this.createCliDownloadUtility(), this.createPhoneHomeDataService(), this.createProjectService(), this.createProjectVersionService(), this.createCodeLocationService(), this.createScanSummaryService(), this.createScanStatusDataService(timeoutInMilliseconds));
    }

    public PhoneHomeDataService createPhoneHomeDataService() {
        return new PhoneHomeDataService(this.restConnection.logger, this.createPhoneHomeClient(), this.createHubRegistrationService(), this.createHubVersionService());
    }

    public PhoneHomeClient createPhoneHomeClient() {
        return new PhoneHomeClient(this.restConnection.logger, this.restConnection.timeout, this.restConnection.getProxyInfo(), this.restConnection.alwaysTrustServerCertificate);
    }

    public RiskReportDataService createRiskReportDataService(long timeoutInMilliseconds) throws IntegrationException {
        return new RiskReportDataService(this.restConnection.logger, this.restConnection, this.createProjectService(), this.createProjectVersionService(), this.createReportService(timeoutInMilliseconds), this.createAggregateBomService(), this.createCheckedHubSupport(), this.createIntegrationEscapeUtil());
    }

    public PolicyStatusDataService createPolicyStatusDataService() {
        return new PolicyStatusDataService(this.restConnection, this.createProjectService(), this.createProjectVersionService());
    }

    public ScanStatusDataService createScanStatusDataService(long timeoutInMilliseconds) {
        return new ScanStatusDataService(this.restConnection.logger, this.createProjectService(), this.createProjectVersionService(), this.createCodeLocationService(), this.createScanSummaryService(), timeoutInMilliseconds);
    }

    public NotificationDataService createNotificationDataService() {
        return new NotificationDataService(this.restConnection.logger, this.createHubService(), this.createNotificationService(), this.createProjectVersionService(), this.createPolicyService());
    }

    public NotificationDataService createNotificationDataService(PolicyNotificationFilter policyNotificationFilter) {
        return new NotificationDataService(this.restConnection.logger, this.createHubService(), this.createNotificationService(), this.createProjectVersionService(), this.createPolicyService(), policyNotificationFilter);
    }

    public ExtensionConfigDataService createExtensionConfigDataService() {
        return new ExtensionConfigDataService(this.restConnection.logger, this.restConnection, this.createUserService(), this.createExtensionConfigService(), this.createExtensionUserOptionService());
    }

    public VulnerabilityDataService createVulnerabilityDataService() {
        return new VulnerabilityDataService(this.restConnection.logger, this.createComponentService(), this.createVulnerabilityService());
    }

    public LicenseDataService createLicenseDataService() {
        return new LicenseDataService(this.createComponentService(), this.createLicenseService());
    }

    public BomImportService createBomImportService() {
        return new BomImportService(this.restConnection);
    }

    public DryRunUploadService createDryRunUploadService() {
        return new DryRunUploadService(this.restConnection);
    }

    public CodeLocationService createCodeLocationService() {
        return new CodeLocationService(this.restConnection);
    }

    public ComponentService createComponentService() {
        return new ComponentService(this.restConnection);
    }

    public HubVersionService createHubVersionService() {
        return new HubVersionService(this.restConnection);
    }

    public NotificationService createNotificationService() {
        return new NotificationService(this.restConnection);
    }

    public PolicyService createPolicyService() {
        return new PolicyService(this.restConnection);
    }

    public ProjectService createProjectService() {
        return new ProjectService(this.restConnection);
    }

    public ProjectVersionService createProjectVersionService() {
        return new ProjectVersionService(this.restConnection);
    }

    public LicenseService createLicenseService() {
        return new LicenseService(this.restConnection);
    }

    public ScanSummaryService createScanSummaryService() {
        return new ScanSummaryService(this.restConnection);
    }

    public UserService createUserService() {
        return new UserService(this.restConnection);
    }

    public GroupService createGroupService() {
        return new GroupService(this.restConnection);
    }

    public VulnerabilityService createVulnerabilityService() {
        return new VulnerabilityService(this.restConnection);
    }

    public ExtensionConfigService createExtensionConfigService() {
        return new ExtensionConfigService(this.restConnection);
    }

    public ExtensionUserOptionService createExtensionUserOptionService() {
        return new ExtensionUserOptionService(this.restConnection);
    }

    public VulnerableBomComponentService createVulnerableBomComponentService() {
        return new VulnerableBomComponentService(this.restConnection);
    }

    public MatchedFilesService createMatchedFilesService() {
        return new MatchedFilesService(this.restConnection);
    }

    public CLIDownloadUtility createCliDownloadUtility() {
        return new CLIDownloadUtility(this.restConnection.logger, this.restConnection);
    }

    public IntegrationEscapeUtil createIntegrationEscapeUtil() {
        return new IntegrationEscapeUtil();
    }

    public SimpleScanUtility createSimpleScanUtility(RestConnection restConnection, HubServerConfig hubServerConfig, HubSupportHelper hubSupportHelper, HubScanConfig hubScanConfig, String projectName, String versionName) {
        return new SimpleScanUtility(restConnection.logger, restConnection.gson, hubServerConfig, hubSupportHelper, this.ciEnvironmentVariables, hubScanConfig, projectName, versionName);
    }

    public HubRegistrationService createHubRegistrationService() {
        return new HubRegistrationService(this.restConnection);
    }

    public ReportService createReportService(long timeoutInMilliseconds) {
        return new ReportService(this.restConnection, this.restConnection.logger, timeoutInMilliseconds);
    }

    public AggregateBomService createAggregateBomService() {
        return new AggregateBomService(this.restConnection);
    }

    public HubService createHubService() {
        return new HubService(this.restConnection);
    }

    public ProjectAssignmentService createProjectAssignmentService() {
        return new ProjectAssignmentService(this.restConnection);
    }

    public RestConnection getRestConnection() {
        return this.restConnection;
    }

    public HubSupportHelper createCheckedHubSupport() throws IntegrationException {
        HubSupportHelper supportHelper = new HubSupportHelper();
        supportHelper.checkHubSupport(this.createHubVersionService(), this.restConnection.logger);
        return supportHelper;
    }

    public ComponentDataService createComponentDataService() {
        return new ComponentDataService(this.restConnection.logger, this.createProjectService(), this.createProjectVersionService(), this.createComponentService(), this.createAggregateBomService(), this.createMatchedFilesService());
    }

    public BomComponentIssueService createBomComponentIssueService() {
        return new BomComponentIssueService(this.restConnection);
    }

    public ProjectDataService createProjectDataService() {
        return new ProjectDataService(this.restConnection, this.createProjectService(), this.createProjectVersionService(), this.createProjectAssignmentService());
    }

    public UserDataService createUserDataService() {
        return new UserDataService(this.restConnection.logger, this.createProjectService(), this.createUserService());
    }

    public String toString() {
        return ReflectionToStringBuilder.toString(this, RecursiveToStringStyle.JSON_STYLE);
    }
}

