/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.validator;

import com.blackducksoftware.integration.hub.scan.HubScanConfigFieldEnum;
import com.blackducksoftware.integration.validator.AbstractValidator;
import com.blackducksoftware.integration.validator.ValidationResult;
import com.blackducksoftware.integration.validator.ValidationResultEnum;
import com.blackducksoftware.integration.validator.ValidationResults;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class HubScanConfigValidator
extends AbstractValidator {
    public static final int DEFAULT_MEMORY_IN_MEGABYTES = 4096;
    public static final int DEFAULT_BOM_UPDATE_WAIT_TIME_IN_MINUTES = 5;
    public static final int MINIMUM_MEMORY_IN_MEGABYTES = 256;
    private File workingDirectory;
    private String scanMemory;
    private final Set<String> scanTargetPaths = new HashSet<String>();
    private String[] excludePatterns;
    private boolean disableScanTargetPathExistenceCheck;
    private boolean enableScanTargetPathsWithinWorkingDirectoryCheck;

    @Override
    public ValidationResults assertValid() {
        ValidationResults result = new ValidationResults();
        this.validateScanMemory(result, 4096);
        this.validateScanTargetPaths(result, this.workingDirectory);
        this.validateExcludePatterns(result);
        return result;
    }

    public void validateScanMemory(ValidationResults result) {
        this.validateScanMemory(result, null);
    }

    private void validateScanMemory(ValidationResults result, Integer defaultScanMemory) {
        if (StringUtils.isBlank(this.scanMemory)) {
            result.addResult(HubScanConfigFieldEnum.SCANMEMORY, new ValidationResult(ValidationResultEnum.ERROR, "No scan memory was specified."));
            return;
        }
        int scanMemoryInt = 0;
        try {
            scanMemoryInt = this.stringToInteger(this.scanMemory);
        }
        catch (IllegalArgumentException e) {
            result.addResult(HubScanConfigFieldEnum.SCANMEMORY, new ValidationResult(ValidationResultEnum.ERROR, e.getMessage()));
            return;
        }
        if (scanMemoryInt < 256) {
            result.addResult(HubScanConfigFieldEnum.SCANMEMORY, new ValidationResult(ValidationResultEnum.ERROR, "The minimum amount of memory for the scan is 256 MB."));
        }
    }

    public void validateScanTargetPaths(ValidationResults result) {
        this.validateScanTargetPaths(result, null);
    }

    private void validateScanTargetPaths(ValidationResults result, File defaultTargetPath) {
        try {
            if (this.scanTargetPaths.isEmpty() && defaultTargetPath != null) {
                this.scanTargetPaths.add(defaultTargetPath.getCanonicalPath());
            }
            HashSet<String> targetPaths = new HashSet<String>();
            for (String currentTargetPath : this.scanTargetPaths) {
                String targetPath = StringUtils.isBlank(currentTargetPath) && defaultTargetPath != null ? defaultTargetPath.getCanonicalPath() : currentTargetPath;
                targetPaths.add(targetPath);
                if (this.disableScanTargetPathExistenceCheck || !StringUtils.isNotBlank(targetPath)) continue;
                File target = new File(targetPath);
                if (target == null || !target.exists()) {
                    result.addResult(HubScanConfigFieldEnum.TARGETS, new ValidationResult(ValidationResultEnum.ERROR, "The scan target '" + target.getCanonicalPath() + "' does not exist or can not be read."));
                }
                if (!this.enableScanTargetPathsWithinWorkingDirectoryCheck) continue;
                try {
                    String targetCanonicalPath = target.getCanonicalPath();
                    if (targetCanonicalPath.startsWith(this.workingDirectory.getCanonicalPath())) continue;
                    result.addResult(HubScanConfigFieldEnum.TARGETS, new ValidationResult(ValidationResultEnum.ERROR, "Can not scan targets outside the working directory."));
                }
                catch (IOException e) {
                    result.addResult(HubScanConfigFieldEnum.TARGETS, new ValidationResult(ValidationResultEnum.ERROR, "Could not get the canonical path for Target : " + targetPath));
                }
            }
            this.scanTargetPaths.clear();
            this.scanTargetPaths.addAll(targetPaths);
        }
        catch (IOException e) {
            result.addResult(HubScanConfigFieldEnum.TARGETS, new ValidationResult(ValidationResultEnum.ERROR, e.getMessage(), e));
        }
    }

    public void validateExcludePatterns(ValidationResults result) {
        this.validateExcludePatterns(result, this.excludePatterns);
    }

    private void validateExcludePatterns(ValidationResults result, String[] excludePatterns) {
        if (excludePatterns == null || excludePatterns.length == 0) {
            return;
        }
        for (String excludePattern : excludePatterns) {
            this.validateExcludePattern(result, excludePattern);
        }
    }

    public void validateExcludePattern(ValidationResults result, String excludePattern) {
        if (StringUtils.isNotBlank(excludePattern)) {
            if (!excludePattern.startsWith("/")) {
                result.addResult(HubScanConfigFieldEnum.EXCLUDE_PATTERNS, new ValidationResult(ValidationResultEnum.WARN, "The exclusion pattern : " + excludePattern + " must start with a /."));
            }
            if (!excludePattern.endsWith("/")) {
                result.addResult(HubScanConfigFieldEnum.EXCLUDE_PATTERNS, new ValidationResult(ValidationResultEnum.WARN, "The exclusion pattern : " + excludePattern + " must end with a /."));
            }
            if (excludePattern.contains("**")) {
                result.addResult(HubScanConfigFieldEnum.EXCLUDE_PATTERNS, new ValidationResult(ValidationResultEnum.WARN, " The exclusion pattern : " + excludePattern + " can not contain **."));
            }
        }
    }

    public void setScanMemory(int scanMemory) {
        this.setScanMemory(String.valueOf(scanMemory));
    }

    public void setScanMemory(String scanMemory) {
        this.scanMemory = scanMemory;
    }

    public void addScanTargetPath(String scanTargetPath) {
        this.scanTargetPaths.add(scanTargetPath);
    }

    public void addAllScanTargetPaths(Set<String> scanTargetPaths) {
        this.scanTargetPaths.addAll(scanTargetPaths);
    }

    public void setExcludePatterns(String[] excludePatterns) {
        this.excludePatterns = excludePatterns;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void disableScanTargetPathExistenceCheck() {
        this.disableScanTargetPathExistenceCheck = true;
    }

    public void enableScanTargetPathsWithinWorkingDirectoryCheck() {
        this.enableScanTargetPathsWithinWorkingDirectoryCheck = true;
    }
}

