/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.phonehome;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.proxy.ProxyInfo;
import com.blackducksoftware.integration.hub.request.HubRequest;
import com.blackducksoftware.integration.hub.rest.RestConnection;
import com.blackducksoftware.integration.hub.rest.UnauthenticatedRestConnectionBuilder;
import com.blackducksoftware.integration.log.IntLogger;
import com.blackducksoftware.integration.phonehome.PhoneHomeRequestBody;
import com.blackducksoftware.integration.phonehome.exception.PhoneHomeException;
import java.net.MalformedURLException;
import java.net.URL;

public class PhoneHomeClient {
    public static final String PHONE_HOME_BACKEND = "https://collect.blackducksoftware.com";
    private final IntLogger logger;
    private URL phoneHomeBackendUrl;
    private final int timeout;
    private final ProxyInfo proxyInfo;
    private final boolean alwaysTrustServerCertificate;

    public PhoneHomeClient(IntLogger logger, int timeout, ProxyInfo proxyInfo, boolean alwaysTrustServerCertificate) {
        this.logger = logger;
        try {
            this.phoneHomeBackendUrl = new URL(PHONE_HOME_BACKEND);
        }
        catch (MalformedURLException e) {
            this.phoneHomeBackendUrl = null;
        }
        this.timeout = timeout;
        this.proxyInfo = proxyInfo;
        this.alwaysTrustServerCertificate = alwaysTrustServerCertificate;
    }

    public PhoneHomeClient(IntLogger logger, URL phoneHomeBackendUrl, int timeout, ProxyInfo proxyInfo, boolean alwaysTrustServerCertificate) {
        this.logger = logger;
        this.phoneHomeBackendUrl = phoneHomeBackendUrl;
        this.timeout = timeout;
        this.proxyInfo = proxyInfo;
        this.alwaysTrustServerCertificate = alwaysTrustServerCertificate;
    }

    public void postPhoneHomeRequest(PhoneHomeRequestBody phoneHomeRequestBody) throws PhoneHomeException {
        if (this.phoneHomeBackendUrl == null) {
            throw new PhoneHomeException("No phone home server found.");
        }
        this.logger.debug("Phoning home to " + this.phoneHomeBackendUrl);
        UnauthenticatedRestConnectionBuilder builder = new UnauthenticatedRestConnectionBuilder();
        builder.setLogger(this.logger);
        builder.setBaseUrl(this.phoneHomeBackendUrl.toString());
        builder.setTimeout(this.timeout);
        builder.applyProxyInfo(this.proxyInfo);
        builder.setAlwaysTrustServerCertificate(this.alwaysTrustServerCertificate);
        RestConnection restConnection = (RestConnection)builder.build();
        HubRequest request = new HubRequest(restConnection);
        try {
            request.executePost(restConnection.gson.toJson(phoneHomeRequestBody));
        }
        catch (IntegrationException e) {
            throw new PhoneHomeException(e.getMessage(), e);
        }
    }
}

