/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.test;

import com.blackducksoftware.integration.log.IntLogger;
import com.blackducksoftware.integration.log.LogLevel;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TestLogger
extends IntLogger {
    private List<String> outputList = new ArrayList<String>();
    private List<Throwable> errorList = new ArrayList<Throwable>();
    private LogLevel logLevel = LogLevel.TRACE;

    public List<String> getOutputList() {
        return this.outputList;
    }

    public List<Throwable> getErrorList() {
        return this.errorList;
    }

    public void resetOutputList() {
        this.outputList = new ArrayList<String>();
    }

    public void resetErrorList() {
        this.errorList = new ArrayList<Throwable>();
    }

    public void resetAllOutput() {
        this.resetOutputList();
        this.resetErrorList();
    }

    public String getOutputString() {
        return StringUtils.join(this.outputList, System.getProperty("line.separator"));
    }

    public String getErrorOutputString() {
        if (this.errorList == null || this.errorList.isEmpty()) {
            return "";
        }
        ArrayList<String> stackTraces = new ArrayList<String>();
        for (Throwable e : this.errorList) {
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            stackTraces.add(stringWriter.toString());
        }
        return StringUtils.join(stackTraces, System.getProperty("line.separator"));
    }

    @Override
    public void alwaysLog(String txt) {
        System.out.println(String.format("always log: %s", txt));
        this.outputList.add(txt);
    }

    @Override
    public void debug(String txt) {
        System.out.println(String.format("debug: %s", txt));
        this.outputList.add(txt);
    }

    @Override
    public void debug(String txt, Throwable e) {
        System.out.println(String.format("debug: %s, exception: %s", txt, e.getMessage()));
        this.outputList.add(txt);
        this.errorList.add(e);
    }

    @Override
    public void error(Throwable e) {
        System.out.println(String.format("error: exception: %s", e.getMessage()));
        this.errorList.add(e);
    }

    @Override
    public void error(String txt) {
        System.out.println(String.format("error: %s", txt));
        this.outputList.add(txt);
    }

    @Override
    public void error(String txt, Throwable e) {
        System.out.println(String.format("error: %s, exception: %s", txt, e.getMessage()));
        this.outputList.add(txt);
        this.errorList.add(e);
    }

    @Override
    public void info(String txt) {
        System.out.println(String.format("info: %s", txt));
        this.outputList.add(txt);
    }

    @Override
    public void trace(String txt) {
        this.outputList.add(txt);
    }

    @Override
    public void trace(String txt, Throwable e) {
        this.outputList.add(txt);
        this.errorList.add(e);
    }

    @Override
    public void warn(String txt) {
        System.out.println(String.format("warn: %s", txt));
        this.outputList.add(txt);
    }

    @Override
    public void setLogLevel(LogLevel level) {
        this.logLevel = level;
    }

    @Override
    public LogLevel getLogLevel() {
        return this.logLevel;
    }
}

