/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.builder;

import com.blackducksoftware.integration.validator.AbstractValidator;
import com.blackducksoftware.integration.validator.ValidationResults;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractBuilder<Type> {
    public abstract AbstractValidator createValidator();

    public abstract Type buildObject();

    public Type build() throws IllegalStateException {
        AbstractValidator validator = this.createValidator();
        ValidationResults results = validator.assertValid();
        if (results.isSuccess()) {
            return this.buildObject();
        }
        String exceptionMessage = "Invalid Configuration: ";
        exceptionMessage = exceptionMessage + results.getAllResultString();
        throw new IllegalStateException(exceptionMessage);
    }

    public boolean isValid() {
        AbstractValidator validator = this.createValidator();
        ValidationResults results = validator.assertValid();
        return results.isSuccess();
    }

    protected int stringToInteger(String integer) throws IllegalArgumentException {
        String integerString = StringUtils.trimToNull(integer);
        if (integerString != null) {
            try {
                return Integer.valueOf(integerString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("The String : " + integer + " , is not an Integer.", e);
            }
        }
        throw new IllegalArgumentException("The String : " + integer + " , is not an Integer.");
    }
}

