/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.api.aggregate.bom;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.model.view.ProjectVersionView;
import com.blackducksoftware.integration.hub.model.view.VersionBomComponentView;
import com.blackducksoftware.integration.hub.request.HubRequest;
import com.blackducksoftware.integration.hub.rest.RestConnection;
import com.blackducksoftware.integration.hub.service.HubService;
import java.io.Closeable;
import java.util.List;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;

public class AggregateBomService
extends HubService {
    public AggregateBomService(RestConnection restConnection) {
        super(restConnection);
    }

    public List<VersionBomComponentView> getBomEntries(ProjectVersionView projectVersion) throws IntegrationException {
        return this.getAllViewsFromLinkSafely(projectVersion, "components", VersionBomComponentView.class);
    }

    public List<VersionBomComponentView> getBomEntries(String componentsUrl) throws IntegrationException {
        return this.getAllViews(componentsUrl, VersionBomComponentView.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBomComponent(String mediaType, String projectVersionComponentsUrl, String componentVersionUrl) throws IntegrationException {
        Response response = null;
        try {
            HubRequest hubRequest = this.getHubRequestFactory().createRequest(projectVersionComponentsUrl);
            response = hubRequest.executePost(mediaType, "{\"component\": \"" + componentVersionUrl + "\"}");
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(response);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)response);
    }
}

