/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.api.project.version;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.exception.DoesNotExistException;
import com.blackducksoftware.integration.hub.model.request.ProjectVersionRequest;
import com.blackducksoftware.integration.hub.model.view.ProjectVersionView;
import com.blackducksoftware.integration.hub.model.view.ProjectView;
import com.blackducksoftware.integration.hub.request.HubPagedRequest;
import com.blackducksoftware.integration.hub.request.HubRequest;
import com.blackducksoftware.integration.hub.rest.RestConnection;
import com.blackducksoftware.integration.hub.service.HubService;
import java.util.List;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;

public class ProjectVersionService
extends HubService {
    public ProjectVersionService(RestConnection restConnection) {
        super(restConnection);
    }

    public ProjectVersionView getProjectVersion(ProjectView project, String projectVersionName) throws IntegrationException {
        String versionsUrl = this.getFirstLink(project, "versions");
        HubPagedRequest hubPagedRequest = this.getHubRequestFactory().createPagedRequest(100, versionsUrl);
        if (StringUtils.isNotBlank(projectVersionName)) {
            hubPagedRequest.q = String.format("versionName:%s", projectVersionName);
        }
        List<ProjectVersionView> allProjectVersionMatchingItems = this.getAllViews(hubPagedRequest, ProjectVersionView.class);
        for (ProjectVersionView projectVersion : allProjectVersionMatchingItems) {
            if (!projectVersionName.equals(projectVersion.versionName)) continue;
            return projectVersion;
        }
        throw new DoesNotExistException(String.format("Could not find the version: %s for project: %s", projectVersionName, project.name));
    }

    public List<ProjectVersionView> getAllProjectVersions(ProjectView project) throws IntegrationException {
        return this.getAllViewsFromLink(project, "versions", ProjectVersionView.class);
    }

    public List<ProjectVersionView> getAllProjectVersions(String versionsUrl) throws IntegrationException {
        List<ProjectVersionView> allProjectVersionItems = this.getAllViews(versionsUrl, ProjectVersionView.class);
        return allProjectVersionItems;
    }

    public String createHubVersion(ProjectView project, ProjectVersionRequest version) throws IntegrationException {
        return this.createHubVersion(this.getFirstLink(project, "versions"), version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createHubVersion(String versionsUrl, ProjectVersionRequest version) throws IntegrationException {
        HubRequest hubRequest = this.getHubRequestFactory().createRequest(versionsUrl);
        try (Response response = null;){
            response = hubRequest.executePost(this.getGson().toJson(version));
            String string = response.header("location");
            return string;
        }
    }
}

