/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.api.report;

import com.blackducksoftware.integration.hub.api.report.AggregateBomViewEntry;
import com.blackducksoftware.integration.hub.api.report.VersionReport;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class HubRiskReportData {
    private VersionReport report;
    private int totalBomEntries;
    private int vulnerabilityRiskHighCount;
    private int vulnerabilityRiskMediumCount;
    private int vulnerabilityRiskLowCount;
    private int vulnerabilityRiskNoneCount;
    private int licenseRiskHighCount;
    private int licenseRiskMediumCount;
    private int licenseRiskLowCount;
    private int licenseRiskNoneCount;
    private int operationalRiskHighCount;
    private int operationalRiskMediumCount;
    private int operationalRiskLowCount;
    private int operationalRiskNoneCount;

    public void setReport(VersionReport report) {
        this.report = report;
        this.vulnerabilityRiskHighCount = 0;
        this.vulnerabilityRiskMediumCount = 0;
        this.vulnerabilityRiskLowCount = 0;
        this.licenseRiskHighCount = 0;
        this.licenseRiskMediumCount = 0;
        this.licenseRiskLowCount = 0;
        this.operationalRiskHighCount = 0;
        this.operationalRiskMediumCount = 0;
        this.operationalRiskLowCount = 0;
        List<AggregateBomViewEntry> bomEntries = report.getAggregateBomViewEntries();
        for (AggregateBomViewEntry bomEntry : bomEntries) {
            if (bomEntry == null) continue;
            if (bomEntry.getVulnerabilityRisk() != null) {
                if (bomEntry.getVulnerabilityRisk().getHIGH() > 0) {
                    ++this.vulnerabilityRiskHighCount;
                } else if (bomEntry.getVulnerabilityRisk().getMEDIUM() > 0) {
                    ++this.vulnerabilityRiskMediumCount;
                } else if (bomEntry.getVulnerabilityRisk().getLOW() > 0) {
                    ++this.vulnerabilityRiskLowCount;
                }
            }
            if (bomEntry.getLicenseRisk() != null) {
                if (bomEntry.getLicenseRisk().getHIGH() > 0) {
                    ++this.licenseRiskHighCount;
                } else if (bomEntry.getLicenseRisk().getMEDIUM() > 0) {
                    ++this.licenseRiskMediumCount;
                } else if (bomEntry.getLicenseRisk().getLOW() > 0) {
                    ++this.licenseRiskLowCount;
                }
            }
            if (bomEntry.getOperationalRisk() == null) continue;
            if (bomEntry.getOperationalRisk().getHIGH() > 0) {
                ++this.operationalRiskHighCount;
                continue;
            }
            if (bomEntry.getOperationalRisk().getMEDIUM() > 0) {
                ++this.operationalRiskMediumCount;
                continue;
            }
            if (bomEntry.getOperationalRisk().getLOW() <= 0) continue;
            ++this.operationalRiskLowCount;
        }
        this.totalBomEntries = bomEntries.size();
        this.vulnerabilityRiskNoneCount = this.totalBomEntries - this.vulnerabilityRiskHighCount - this.vulnerabilityRiskMediumCount - this.vulnerabilityRiskLowCount;
        this.licenseRiskNoneCount = this.totalBomEntries - this.licenseRiskHighCount - this.licenseRiskMediumCount - this.licenseRiskLowCount;
        this.operationalRiskNoneCount = this.totalBomEntries - this.operationalRiskHighCount - this.operationalRiskMediumCount - this.operationalRiskLowCount;
    }

    public double getPercentage(double count) {
        double totalCount = this.totalBomEntries;
        double percentage = 0.0;
        if (totalCount > 0.0 && count > 0.0) {
            percentage = count / totalCount * 100.0;
        }
        return percentage;
    }

    public String htmlEscape(String valueToEscape) {
        if (StringUtils.isBlank(valueToEscape)) {
            return null;
        }
        return StringEscapeUtils.escapeHtml4(valueToEscape);
    }

    public List<AggregateBomViewEntry> getBomEntries() {
        return this.report.getAggregateBomViewEntries();
    }

    public VersionReport getReport() {
        return this.report;
    }

    public int getVulnerabilityRiskHighCount() {
        return this.vulnerabilityRiskHighCount;
    }

    public int getVulnerabilityRiskMediumCount() {
        return this.vulnerabilityRiskMediumCount;
    }

    public int getVulnerabilityRiskLowCount() {
        return this.vulnerabilityRiskLowCount;
    }

    public int getVulnerabilityRiskNoneCount() {
        return this.vulnerabilityRiskNoneCount;
    }

    public int getLicenseRiskHighCount() {
        return this.licenseRiskHighCount;
    }

    public int getLicenseRiskMediumCount() {
        return this.licenseRiskMediumCount;
    }

    public int getLicenseRiskLowCount() {
        return this.licenseRiskLowCount;
    }

    public int getLicenseRiskNoneCount() {
        return this.licenseRiskNoneCount;
    }

    public int getOperationalRiskHighCount() {
        return this.operationalRiskHighCount;
    }

    public int getOperationalRiskMediumCount() {
        return this.operationalRiskMediumCount;
    }

    public int getOperationalRiskLowCount() {
        return this.operationalRiskLowCount;
    }

    public int getOperationalRiskNoneCount() {
        return this.operationalRiskNoneCount;
    }
}

