/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.api.view;

import com.blackducksoftware.integration.hub.exception.HubIntegrationException;
import com.blackducksoftware.integration.hub.model.HubView;
import com.blackducksoftware.integration.hub.model.enumeration.AllowEnum;
import com.blackducksoftware.integration.hub.model.view.components.LinkView;
import com.blackducksoftware.integration.hub.model.view.components.MetaView;
import com.blackducksoftware.integration.log.IntLogger;
import java.util.ArrayList;
import java.util.List;

public class MetaHandler {
    public static final String PROJECTS_LINK = "projects";
    public static final String PROJECT_LINK = "project";
    public static final String VERSIONS_LINK = "versions";
    public static final String VERSION_LINK = "versions";
    public static final String CANONICAL_VERSION_LINK = "canonicalVersion";
    public static final String VERSION_REPORT_LINK = "versionReport";
    public static final String VERSION_NOTICES_REPORT_LINK = "licenseReports";
    public static final String COMPONENTS_LINK = "components";
    public static final String POLICY_RULES_LINK = "policy-rules";
    public static final String POLICY_RULE_LINK = "policy-rule";
    public static final String POLICY_STATUS_LINK = "policy-status";
    public static final String RISK_PROFILE_LINK = "riskProfile";
    public static final String VULNERABILITIES_LINK = "vulnerabilities";
    public static final String VULNERABLE_COMPONENTS_LINK = "vulnerable-components";
    public static final String MATCHED_FILES_LINK = "matched-files";
    public static final String CONTENT_LINK = "content";
    public static final String DOWNLOAD_LINK = "download";
    public static final String CODE_LOCATION_LINK = "codelocations";
    public static final String CODE_LOCATION_BOM_STATUS_LINK = "codelocation";
    public static final String SCANS_LINK = "scans";
    public static final String NOTIFICATIONS_LINK = "notifications";
    public static final String USERS_LINK = "users";
    public static final String GROUPS_LINK = "usergroups";
    public static final String GLOBAL_OPTIONS_LINK = "global-options";
    public static final String USER_OPTIONS_LINK = "user-options";
    public static final String LICENSE_LINK = "license";
    public static final String TEXT_LINK = "text";
    public static final String ROLES_LINK = "roles";
    private final IntLogger logger;

    public MetaHandler(IntLogger logger) {
        this.logger = logger;
    }

    public boolean hasLink(HubView view, String linkKey) throws HubIntegrationException {
        MetaView meta = view.meta;
        if (meta == null) {
            return false;
        }
        List<LinkView> links = meta.links;
        if (links == null) {
            return false;
        }
        for (LinkView link : links) {
            if (!link.rel.equals(linkKey)) continue;
            return true;
        }
        return false;
    }

    public String getFirstLink(HubView view, String linkKey) throws HubIntegrationException {
        List<LinkView> links = this.getLinkViews(view);
        StringBuilder linksAvailable = new StringBuilder();
        linksAvailable.append("Could not find the link '" + linkKey + "', these are the available links : ");
        int i = 0;
        for (LinkView link : links) {
            if (link.rel.equals(linkKey)) {
                return link.href;
            }
            if (i > 0) {
                linksAvailable.append(", ");
            }
            linksAvailable.append("'" + link.rel + "'");
            ++i;
        }
        linksAvailable.append(". For View : " + view.meta.href);
        throw new HubIntegrationException(linksAvailable.toString());
    }

    public String getFirstLinkSafely(HubView view, String linkKey) {
        try {
            String link = this.getFirstLink(view, linkKey);
            return link;
        }
        catch (HubIntegrationException e) {
            this.logger.debug("Link '" + linkKey + "' not found on view : " + view.json, e);
            return null;
        }
    }

    public List<String> getLinks(HubView view, String linkKey) throws HubIntegrationException {
        List<LinkView> links = this.getLinkViews(view);
        ArrayList<String> linkHrefs = new ArrayList<String>();
        StringBuilder linksAvailable = new StringBuilder();
        linksAvailable.append("Could not find the link '" + linkKey + "', these are the available links : ");
        int i = 0;
        for (LinkView link : links) {
            if (link.rel.equals(linkKey)) {
                linkHrefs.add(link.href);
            }
            if (i > 0) {
                linksAvailable.append(", ");
            }
            linksAvailable.append("'" + link.rel + "'");
            ++i;
        }
        if (!linkHrefs.isEmpty()) {
            return linkHrefs;
        }
        linksAvailable.append(". For View : " + view.meta.href);
        throw new HubIntegrationException(linksAvailable.toString());
    }

    public MetaView getMetaView(HubView view) throws HubIntegrationException {
        MetaView meta = view.meta;
        if (meta == null) {
            throw new HubIntegrationException("Could not find meta information for this view : " + view.json);
        }
        return meta;
    }

    public List<LinkView> getLinkViews(HubView view) throws HubIntegrationException {
        MetaView meta = this.getMetaView(view);
        List<LinkView> links = meta.links;
        if (links == null) {
            throw new HubIntegrationException("Could not find any links for this view : " + view.json);
        }
        return links;
    }

    public List<AllowEnum> getAllowedMethods(HubView view) throws HubIntegrationException {
        MetaView meta = this.getMetaView(view);
        return meta.allow;
    }

    public String getHref(HubView view) throws HubIntegrationException {
        MetaView meta = this.getMetaView(view);
        String href = meta.href;
        if (href == null) {
            if (this.logger != null) {
                this.logger.error("Hub View has no href : " + view.json);
            }
            throw new HubIntegrationException("This Hub view does not have any href information.");
        }
        return href;
    }
}

