/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.dataservice.component.model;

import com.blackducksoftware.integration.hub.dataservice.component.model.MatchedFilesModel;
import com.blackducksoftware.integration.hub.dataservice.model.RiskProfileCounts;
import com.blackducksoftware.integration.hub.model.enumeration.MatchTypeEnum;
import com.blackducksoftware.integration.hub.model.enumeration.MatchedFileUsageEnum;
import com.blackducksoftware.integration.hub.model.enumeration.ReviewStatusEnum;
import com.blackducksoftware.integration.hub.model.enumeration.RiskCountEnum;
import com.blackducksoftware.integration.hub.model.view.MatchedFilesView;
import com.blackducksoftware.integration.hub.model.view.VersionBomComponentView;
import com.blackducksoftware.integration.hub.model.view.components.ActivityDataView;
import com.blackducksoftware.integration.hub.model.view.components.OriginView;
import com.blackducksoftware.integration.hub.model.view.components.ReviewedDetailsView;
import com.blackducksoftware.integration.hub.model.view.components.VersionBomLicenseView;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class VersionBomComponentModel {
    private final VersionBomComponentView component;
    private final List<MatchedFilesModel> matchedFiles;

    public VersionBomComponentModel(VersionBomComponentView component, List<MatchedFilesView> matchedFiles) {
        this.component = component;
        this.matchedFiles = this.getMatchedFilesModel(matchedFiles);
    }

    public ActivityDataView getActivityData() {
        return this.component.activityData;
    }

    public RiskProfileCounts getActivityRiskProfile() {
        return new RiskProfileCounts(this.component.activityRiskProfile);
    }

    public boolean hasActivityRisk() {
        return this.hasRisk(this.getActivityRiskProfile());
    }

    public String getComponent() {
        return this.component.component;
    }

    public String getComponentName() {
        return this.component.componentName;
    }

    public String getComponentVersion() {
        return this.component.componentVersion;
    }

    public String getComponentVersionName() {
        return this.component.componentVersionName;
    }

    public RiskProfileCounts getLicenseRiskProfile() {
        return new RiskProfileCounts(this.component.licenseRiskProfile);
    }

    public boolean hasLicenseRisk() {
        return this.hasRisk(this.getLicenseRiskProfile());
    }

    public List<VersionBomLicenseView> getLicenses() {
        return this.component.licenses;
    }

    public RiskProfileCounts getOperationalRiskProfile() {
        return new RiskProfileCounts(this.component.operationalRiskProfile);
    }

    public boolean hasOperationalRisk() {
        return this.hasRisk(this.getOperationalRiskProfile());
    }

    public List<OriginView> getOrigins() {
        return this.component.origins;
    }

    public List<MatchTypeEnum> getMatchTypes() {
        return this.component.matchTypes;
    }

    public Date getReleasedOn() {
        return this.component.releasedOn;
    }

    public RiskProfileCounts getSecurityRiskProfile() {
        return new RiskProfileCounts(this.component.securityRiskProfile);
    }

    public boolean hasSecurityRisk() {
        return this.hasRisk(this.getSecurityRiskProfile());
    }

    public List<MatchedFileUsageEnum> getUsages() {
        return this.component.usages;
    }

    public RiskProfileCounts getVersionRiskProfile() {
        return new RiskProfileCounts(this.component.versionRiskProfile);
    }

    public boolean hasVersionRisk() {
        return this.hasRisk(this.getVersionRiskProfile());
    }

    public ReviewStatusEnum getReviewStatus() {
        return this.component.reviewStatus;
    }

    public ReviewedDetailsView getReviewedDetails() {
        return this.component.reviewedDetails;
    }

    public String getApprovalStatus() {
        return this.component.approvalStatus;
    }

    public List<MatchedFilesModel> getMatchedFiles() {
        return this.matchedFiles;
    }

    private boolean hasRisk(RiskProfileCounts counts) {
        return counts.getCount(RiskCountEnum.LOW) + counts.getCount(RiskCountEnum.MEDIUM) + counts.getCount(RiskCountEnum.HIGH) > 0;
    }

    private List<MatchedFilesModel> getMatchedFilesModel(List<MatchedFilesView> matchedFiles) {
        ArrayList<MatchedFilesModel> matchedFileModels = new ArrayList<MatchedFilesModel>(matchedFiles.size());
        for (MatchedFilesView matchedFile : matchedFiles) {
            matchedFileModels.add(new MatchedFilesModel(matchedFile));
        }
        return matchedFileModels;
    }
}

