/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.dataservice.model;

import com.blackducksoftware.integration.hub.model.view.PolicyRuleView;
import com.blackducksoftware.integration.hub.model.view.components.PolicyRuleConditionEnum;
import com.blackducksoftware.integration.hub.model.view.components.PolicyRuleExpression;
import java.util.Collections;
import java.util.List;

public class PolicyRuleModel {
    private final PolicyRuleView rule;

    public PolicyRuleModel(PolicyRuleView rule) {
        this.rule = rule;
    }

    public boolean hasExpressions() {
        return this.rule != null && this.rule.expression != null && this.rule.expression.expressions != null && !this.rule.expression.expressions.isEmpty();
    }

    public List<PolicyRuleExpression> getExpressionList() {
        if (this.hasExpressions()) {
            return this.rule.expression.expressions;
        }
        return Collections.emptyList();
    }

    public boolean hasOnlyProjectLevelConditions() {
        boolean hasNonProjectLevelCondition = false;
        for (PolicyRuleExpression expression : this.getExpressionList()) {
            PolicyRuleConditionEnum condition = PolicyRuleConditionEnum.valueOf(expression.name);
            if (condition == PolicyRuleConditionEnum.UNKNOWN_RULE_CONDTION || condition == PolicyRuleConditionEnum.PROJECT_TIER || condition == PolicyRuleConditionEnum.VERSION_PHASE || condition == PolicyRuleConditionEnum.VERSION_DISTRIBUTION) continue;
            hasNonProjectLevelCondition = true;
        }
        return !hasNonProjectLevelCondition;
    }
}

