/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.dataservice.policystatus;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.api.project.ProjectService;
import com.blackducksoftware.integration.hub.api.project.version.ProjectVersionService;
import com.blackducksoftware.integration.hub.exception.HubIntegrationException;
import com.blackducksoftware.integration.hub.model.view.ProjectVersionView;
import com.blackducksoftware.integration.hub.model.view.ProjectView;
import com.blackducksoftware.integration.hub.model.view.VersionBomPolicyStatusView;
import com.blackducksoftware.integration.hub.rest.RestConnection;
import com.blackducksoftware.integration.hub.service.HubService;
import java.util.List;

public class PolicyStatusDataService
extends HubService {
    private final ProjectService projectRequestService;
    private final ProjectVersionService projectVersionRequestService;

    public PolicyStatusDataService(RestConnection restConnection, ProjectService projectRequestService, ProjectVersionService projectVersionRequestService) {
        super(restConnection);
        this.projectRequestService = projectRequestService;
        this.projectVersionRequestService = projectVersionRequestService;
    }

    public VersionBomPolicyStatusView getPolicyStatusForProjectAndVersion(String projectName, String projectVersionName) throws IntegrationException {
        ProjectView projectItem = this.projectRequestService.getProjectByName(projectName);
        String versionsUrl = this.getFirstLink(projectItem, "versions");
        List<ProjectVersionView> projectVersions = this.projectVersionRequestService.getAllProjectVersions(versionsUrl);
        String policyStatusUrl = this.findPolicyStatusUrlFromVersions(projectVersions, projectVersionName);
        return this.getView(policyStatusUrl, VersionBomPolicyStatusView.class);
    }

    public VersionBomPolicyStatusView getPolicyStatusForVersion(ProjectVersionView version) throws IntegrationException {
        String policyStatusUrl = this.getFirstLink(version, "policy-status");
        return this.getView(policyStatusUrl, VersionBomPolicyStatusView.class);
    }

    private String findPolicyStatusUrlFromVersions(List<ProjectVersionView> projectVersions, String projectVersionName) throws HubIntegrationException {
        for (ProjectVersionView version : projectVersions) {
            if (!projectVersionName.equals(version.versionName)) continue;
            String policyStatusLink = this.getFirstLink(version, "policy-status");
            return policyStatusLink;
        }
        return null;
    }
}

