/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.report;

import com.blackducksoftware.integration.hub.report.RiskReportResourceCopier;
import com.blackducksoftware.integration.hub.report.api.ReportData;
import com.blackducksoftware.integration.hub.report.exception.RiskReportException;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class RiskReportWriter {
    private final Gson gson = new Gson();

    public void createHtmlReportFiles(File outputDirectory, ReportData reportData) throws RiskReportException {
        try {
            RiskReportResourceCopier copier = new RiskReportResourceCopier(outputDirectory.getCanonicalPath());
            File htmlFile = null;
            try {
                List<File> writtenFiles = copier.copy();
                for (File file : writtenFiles) {
                    if (!file.getName().equals("riskreport.html")) continue;
                    htmlFile = file;
                    break;
                }
            }
            catch (URISyntaxException e) {
                throw new RiskReportException("Couldn't create the report: " + e.getMessage(), e);
            }
            if (htmlFile == null) {
                throw new RiskReportException("Could not find the file : riskreport.html, the report files must not have been copied into the report directory.");
            }
            String htmlFileString = FileUtils.readFileToString(htmlFile, (String)"UTF-8");
            String reportString = this.gson.toJson(reportData);
            htmlFileString = htmlFileString.replace("TOKEN_RISK_REPORT_JSON_TOKEN", reportString);
            FileUtils.writeStringToFile((File)htmlFile, (String)htmlFileString, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new RiskReportException("Couldn't create the report: " + e.getMessage(), e);
        }
    }
}

