/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.rest;

import com.blackducksoftware.integration.exception.EncryptionException;
import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.certificate.CertTrustManager;
import com.blackducksoftware.integration.hub.proxy.OkAuthenticator;
import com.blackducksoftware.integration.hub.proxy.ProxyInfo;
import com.blackducksoftware.integration.hub.rest.TLSSocketFactory;
import com.blackducksoftware.integration.hub.rest.exception.IntegrationRestException;
import com.blackducksoftware.integration.log.IntLogger;
import com.blackducksoftware.integration.log.LogLevel;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;

public abstract class RestConnection {
    private static final String ERROR_MSG_PROXY_INFO_NULL = "A RestConnection's proxy information cannot be null";
    public static final String JSON_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSX";
    public static final String X_CSRF_TOKEN = "X-CSRF-TOKEN";
    public final Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX").create();
    public final JsonParser jsonParser = new JsonParser();
    public final OkHttpClient.Builder builder = new OkHttpClient.Builder();
    public final Map<String, String> commonRequestHeaders = new HashMap<String, String>();
    public final URL hubBaseUrl;
    public int timeout = 120;
    private final ProxyInfo proxyInfo;
    public boolean alwaysTrustServerCertificate;
    public IntLogger logger;
    private OkHttpClient client;

    public static Date parseDateString(String dateString) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(JSON_DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.parse(dateString);
    }

    public static String formatDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(JSON_DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(date);
    }

    public RestConnection(IntLogger logger, URL hubBaseUrl, int timeout, ProxyInfo proxyInfo) {
        this.logger = logger;
        this.hubBaseUrl = hubBaseUrl;
        this.timeout = timeout;
        this.proxyInfo = proxyInfo;
    }

    public void connect() throws IntegrationException {
        this.addBuilderConnectionTimes();
        this.addBuilderProxyInformation();
        this.addBuilderAuthentication();
        this.addTlsConnectionInfo();
        this.setClient(this.builder.build());
        this.clientAuthenticate();
    }

    public void addTlsConnectionInfo() throws IntegrationException {
        if (this.hubBaseUrl.getProtocol().equalsIgnoreCase("https")) {
            X509TrustManager trustManager = null;
            trustManager = this.alwaysTrustServerCertificate ? new CertTrustManager() : this.systemDefaultTrustManager();
            String version = System.getProperty("java.version");
            SSLSocketFactory sSLSocketFactory = null;
            if (version.startsWith("1.7") || version.startsWith("1.6")) {
                try {
                    sSLSocketFactory = new TLSSocketFactory(trustManager);
                }
                catch (KeyManagementException | NoSuchAlgorithmException e) {
                    throw new IntegrationException(e);
                }
            } else {
                sSLSocketFactory = this.systemDefaultSslSocketFactory(trustManager);
            }
            this.builder.sslSocketFactory(sSLSocketFactory, trustManager);
        }
    }

    private X509TrustManager systemDefaultTrustManager() throws IntegrationException {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            Object[] trustManagers = trustManagerFactory.getTrustManagers();
            if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
            }
            return (X509TrustManager)trustManagers[0];
        }
        catch (GeneralSecurityException e) {
            throw new IntegrationException();
        }
    }

    private SSLSocketFactory systemDefaultSslSocketFactory(X509TrustManager trustManager) throws IntegrationException {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{trustManager}, null);
            return sslContext.getSocketFactory();
        }
        catch (GeneralSecurityException e) {
            throw new IntegrationException(e);
        }
    }

    public abstract void addBuilderAuthentication() throws IntegrationException;

    public abstract void clientAuthenticate() throws IntegrationException;

    private void addBuilderConnectionTimes() {
        this.builder.connectTimeout(this.timeout, TimeUnit.SECONDS);
        this.builder.writeTimeout(this.timeout, TimeUnit.SECONDS);
        this.builder.readTimeout(this.timeout, TimeUnit.SECONDS);
    }

    private void addBuilderProxyInformation() throws IntegrationException {
        if (this.shouldUseProxyForUrl(this.hubBaseUrl)) {
            this.builder.proxy(this.getProxy(this.hubBaseUrl));
            try {
                this.builder.proxyAuthenticator(new OkAuthenticator(this.proxyInfo.getUsername(), this.proxyInfo.getDecryptedPassword()));
            }
            catch (EncryptionException | IllegalArgumentException ex) {
                throw new IntegrationException(ex);
            }
        }
    }

    private Proxy getProxy(URL hubUrl) {
        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyInfo.getHost(), this.proxyInfo.getPort()));
        return proxy;
    }

    private boolean shouldUseProxyForUrl(URL url) {
        if (this.proxyInfo == null) {
            throw new IllegalStateException(ERROR_MSG_PROXY_INFO_NULL);
        }
        return this.proxyInfo.shouldUseProxyForUrl(url);
    }

    public HttpUrl createHttpUrl() {
        return HttpUrl.get(this.hubBaseUrl).newBuilder().build();
    }

    public HttpUrl createHttpUrl(URL providedUrl) {
        HttpUrl.Builder urlBuilder = HttpUrl.get(providedUrl).newBuilder();
        return urlBuilder.build();
    }

    public HttpUrl createHttpUrl(String providedUrl) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse(providedUrl).newBuilder();
        return urlBuilder.build();
    }

    public HttpUrl createHttpUrl(List<String> urlSegments) {
        return this.createHttpUrl(urlSegments, null);
    }

    public HttpUrl createHttpUrl(List<String> urlSegments, Map<String, String> queryParameters) {
        return this.createHttpUrl(this.hubBaseUrl.toString(), urlSegments, queryParameters);
    }

    public HttpUrl createHttpUrl(String providedUrl, List<String> urlSegments, Map<String, String> queryParameters) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse(providedUrl).newBuilder();
        if (urlSegments != null) {
            for (String string : urlSegments) {
                urlBuilder.addPathSegment(string);
            }
        }
        if (queryParameters != null) {
            for (Map.Entry entry : queryParameters.entrySet()) {
                try {
                    String encodedKey = URLEncoder.encode((String)entry.getKey(), "UTF-8");
                    String encodedVal = URLEncoder.encode((String)entry.getValue(), "UTF-8");
                    urlBuilder.addEncodedQueryParameter(encodedKey, encodedVal);
                }
                catch (UnsupportedEncodingException e) {
                    if (this.logger == null) continue;
                    this.logger.error(e);
                }
            }
        }
        return urlBuilder.build();
    }

    public RequestBody createJsonRequestBody(String content) {
        return this.createJsonRequestBody("application/json", content);
    }

    public RequestBody createJsonRequestBody(String mediaType, String content) {
        return RequestBody.create(MediaType.parse(mediaType), content);
    }

    public RequestBody createFileRequestBody(String mediaType, File file) {
        return RequestBody.create(MediaType.parse(mediaType), file);
    }

    public RequestBody createEncodedFormBody(Map<String, String> content) {
        FormBody.Builder builder = new FormBody.Builder();
        for (Map.Entry<String, String> contentEntry : content.entrySet()) {
            builder.add(contentEntry.getKey(), contentEntry.getValue());
        }
        return builder.build();
    }

    public Request createGetRequest(HttpUrl httpUrl) {
        return this.createGetRequest(httpUrl, "application/json");
    }

    public Request createGetRequest(HttpUrl httpUrl, String mediaType) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", mediaType);
        return this.createGetRequest(httpUrl, headers);
    }

    public Request createGetRequest(HttpUrl httpUrl, Map<String, String> headers) {
        return this.getRequestBuilder(headers).url(httpUrl).get().build();
    }

    public Request createPostRequest(HttpUrl httpUrl, RequestBody body) {
        return this.getRequestBuilder().url(httpUrl).post(body).build();
    }

    public Request createPostRequest(HttpUrl httpUrl, Map<String, String> headers, RequestBody body) {
        return this.getRequestBuilder(headers).url(httpUrl).post(body).build();
    }

    public Request createPutRequest(HttpUrl httpUrl, RequestBody body) {
        return this.getRequestBuilder().url(httpUrl).put(body).build();
    }

    public Request createDeleteRequest(HttpUrl httpUrl) {
        return this.getRequestBuilder().url(httpUrl).delete().build();
    }

    private Request.Builder getRequestBuilder() {
        return this.getRequestBuilder(null);
    }

    private Request.Builder getRequestBuilder(Map<String, String> headers) {
        Request.Builder builder = new Request.Builder();
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.putAll(this.commonRequestHeaders);
        if (headers != null) {
            requestHeaders.putAll(headers);
        }
        for (Map.Entry header : requestHeaders.entrySet()) {
            builder.addHeader((String)header.getKey(), (String)header.getValue());
        }
        return builder;
    }

    private Request createNewRequest(Request request) {
        Request.Builder builder = request.newBuilder();
        for (Map.Entry<String, String> entry : this.commonRequestHeaders.entrySet()) {
            builder.header(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    public Response createResponse(Request request) throws IntegrationException {
        return this.handleExecuteClientCall(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Response handleExecuteClientCall(Request request) throws IntegrationException {
        Response response;
        long start = System.currentTimeMillis();
        this.logMessage(LogLevel.TRACE, "starting request: " + request.url());
        try {
            response = this.handleExecuteClientCall(request, 0);
        }
        catch (Throwable throwable) {
            long end = System.currentTimeMillis();
            this.logMessage(LogLevel.TRACE, String.format("completed request: %s (%d ms)", request.url(), end - start));
            throw throwable;
        }
        long end = System.currentTimeMillis();
        this.logMessage(LogLevel.TRACE, String.format("completed request: %s (%d ms)", request.url(), end - start));
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response handleExecuteClientCall(Request request, int retryCount) throws IntegrationException {
        if (this.client == null) {
            this.connect();
            Request newRequest = this.createNewRequest(request);
            return this.handleExecuteClientCall(newRequest, retryCount);
        }
        try {
            URL url = request.url().url();
            String urlString = request.url().uri().toString();
            if (this.alwaysTrustServerCertificate && url.getProtocol().equalsIgnoreCase("https") && this.logger != null) {
                this.logger.debug("Automatically trusting the certificate for " + urlString);
            }
            this.logRequestHeaders(request);
            Response response = this.client.newCall(request).execute();
            if (response.isSuccessful()) {
                this.logResponseHeaders(response);
                return response;
            }
            try {
                if (response.code() == 401 && retryCount < 2) {
                    this.connect();
                    Request newRequest = this.createNewRequest(request);
                    Response response2 = this.handleExecuteClientCall(newRequest, retryCount + 1);
                    return response2;
                }
                throw new IntegrationRestException(response.code(), response.message(), String.format("There was a problem trying to %s this item: %s. Error: %s %s", request.method(), urlString, response.code(), response.message()));
            }
            finally {
                response.close();
            }
        }
        catch (IOException e) {
            throw new IntegrationException(e.getMessage(), e);
        }
    }

    private void logMessage(LogLevel level, String txt) {
        if (this.logger != null) {
            if (level == LogLevel.ERROR) {
                this.logger.error(txt);
            } else if (level == LogLevel.WARN) {
                this.logger.warn(txt);
            } else if (level == LogLevel.INFO) {
                this.logger.info(txt);
            } else if (level == LogLevel.DEBUG) {
                this.logger.debug(txt);
            } else if (level == LogLevel.TRACE) {
                this.logger.trace(txt);
            }
        }
    }

    private boolean isDebugLogging() {
        return this.logger != null && this.logger.getLogLevel() == LogLevel.TRACE;
    }

    protected void logRequestHeaders(Request request) {
        if (this.isDebugLogging()) {
            String requestName = request.getClass().getSimpleName();
            this.logMessage(LogLevel.TRACE, requestName + " : " + request.toString());
            this.logHeaders(requestName, request.headers());
        }
    }

    protected void logResponseHeaders(Response response) {
        if (this.isDebugLogging()) {
            String responseName = response.getClass().getSimpleName();
            this.logMessage(LogLevel.TRACE, responseName + " : " + response.toString());
            this.logHeaders(responseName, response.headers());
        }
    }

    private void logHeaders(String requestOrResponseName, Headers headers) {
        if (headers != null && headers.size() > 0) {
            this.logMessage(LogLevel.TRACE, requestOrResponseName + " headers : ");
            for (Map.Entry<String, List<String>> headerEntry : headers.toMultimap().entrySet()) {
                String key = headerEntry.getKey();
                String value = "null";
                if (headerEntry.getValue() != null && !headerEntry.getValue().isEmpty()) {
                    value = StringUtils.join((Iterable)headerEntry.getValue(), System.lineSeparator());
                }
                this.logMessage(LogLevel.TRACE, String.format("Header %s : %s", key, value));
            }
        } else {
            this.logMessage(LogLevel.TRACE, requestOrResponseName + " does not have any headers.");
        }
    }

    public String toString() {
        return "RestConnection [baseUrl=" + this.hubBaseUrl + "]";
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    public void setClient(OkHttpClient client) {
        this.client = client;
    }

    public ProxyInfo getProxyInfo() {
        return this.proxyInfo;
    }
}

