/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.rest.oauth;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.rest.RestConnection;
import com.blackducksoftware.integration.hub.rest.oauth.AccessType;
import com.blackducksoftware.integration.hub.rest.oauth.TokenManager;
import java.io.IOException;
import okhttp3.Authenticator;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

public class OkOauthAuthenticator
implements Authenticator {
    private final TokenManager tokenManager;
    private final AccessType accessType;
    private final RestConnection restConnection;

    public OkOauthAuthenticator(TokenManager tokenManager, AccessType accessType, RestConnection restConnection) {
        this.tokenManager = tokenManager;
        this.accessType = accessType;
        this.restConnection = restConnection;
    }

    @Override
    public Request authenticate(Route route, Response response) throws IOException {
        String credential;
        if (response.priorResponse() != null) {
            return null;
        }
        try {
            credential = this.tokenManager.createTokenCredential(this.tokenManager.getToken((AccessType)this.accessType).accessToken);
        }
        catch (IntegrationException e) {
            throw new IOException("Cannot refresh token", e);
        }
        this.restConnection.commonRequestHeaders.put("Authorization", credential);
        return response.request().newBuilder().header("Authorization", credential).build();
    }
}

