/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.scan;

import com.blackducksoftware.integration.log.IntLogger;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.RecursiveToStringStyle;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

public class HubScanConfig {
    private final File workingDirectory;
    private final int scanMemory;
    private final Set<String> scanTargetPaths;
    private final boolean dryRun;
    private final File toolsDir;
    private final boolean cleanupLogsOnSuccess;
    private final String[] excludePatterns;
    private final String codeLocationAlias;
    private final boolean unmapPreviousCodeLocations;
    private final boolean deletePreviousCodeLocations;
    private final boolean debug;
    private final boolean verbose;
    private final boolean snippetModeEnabled;

    public HubScanConfig(File workingDirectory, int scanMemory, Set<String> scanTargetPaths, boolean dryRun, File toolsDir, boolean cleanupLogsOnSuccess, String[] excludePatterns, String codeLocationAlias, boolean unmapPreviousCodeLocations, boolean deletePreviousCodeLocations, boolean snippetModeEnabled) {
        this(workingDirectory, scanMemory, scanTargetPaths, dryRun, toolsDir, cleanupLogsOnSuccess, excludePatterns, codeLocationAlias, unmapPreviousCodeLocations, deletePreviousCodeLocations, false, true, snippetModeEnabled);
    }

    public HubScanConfig(File workingDirectory, int scanMemory, Set<String> scanTargetPaths, boolean dryRun, File toolsDir, boolean cleanupLogsOnSuccess, String[] excludePatterns, String codeLocationAlias, boolean unmapPreviousCodeLocations, boolean deletePreviousCodeLocations, boolean debug, boolean verbose, boolean snippetModeEnabled) {
        this.workingDirectory = workingDirectory;
        this.scanMemory = scanMemory;
        this.scanTargetPaths = scanTargetPaths;
        this.dryRun = dryRun;
        this.toolsDir = toolsDir;
        this.cleanupLogsOnSuccess = cleanupLogsOnSuccess;
        this.excludePatterns = excludePatterns;
        this.codeLocationAlias = codeLocationAlias;
        this.unmapPreviousCodeLocations = unmapPreviousCodeLocations;
        this.deletePreviousCodeLocations = deletePreviousCodeLocations;
        this.debug = debug;
        this.verbose = verbose;
        this.snippetModeEnabled = snippetModeEnabled;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public int getScanMemory() {
        return this.scanMemory;
    }

    public Set<String> getScanTargetPaths() {
        return this.scanTargetPaths;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public File getToolsDir() {
        return this.toolsDir;
    }

    public boolean isCleanupLogsOnSuccess() {
        return this.cleanupLogsOnSuccess;
    }

    public String[] getExcludePatterns() {
        return this.excludePatterns;
    }

    public String getCodeLocationAlias() {
        return this.codeLocationAlias;
    }

    public boolean isUnmapPreviousCodeLocations() {
        return this.unmapPreviousCodeLocations;
    }

    public boolean isDeletePreviousCodeLocations() {
        return this.deletePreviousCodeLocations;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isSnippetModeEnabled() {
        return this.snippetModeEnabled;
    }

    public void print(IntLogger logger) {
        try {
            logger.alwaysLog("--> Using Working Directory : " + this.getWorkingDirectory().getCanonicalPath());
        }
        catch (IOException e) {
            logger.alwaysLog("Extremely unlikely exception getting the canonical path: " + e.getMessage());
        }
        logger.alwaysLog("--> Scanning the following targets  : ");
        if (this.scanTargetPaths != null) {
            for (String target : this.scanTargetPaths) {
                logger.alwaysLog("--> " + target);
            }
        } else {
            logger.alwaysLog("--> null");
        }
        logger.alwaysLog("--> Directory Exclusion Patterns  : ");
        if (this.excludePatterns != null) {
            for (String exclusionPattern : this.excludePatterns) {
                logger.alwaysLog("--> " + exclusionPattern);
            }
        } else {
            logger.alwaysLog("--> null");
        }
        logger.alwaysLog("--> Scan Memory : " + this.getScanMemory());
        logger.alwaysLog("--> Dry Run : " + this.isDryRun());
        logger.alwaysLog("--> Clean-up logs on success : " + this.isCleanupLogsOnSuccess());
        logger.alwaysLog("--> Code Location Name : " + this.getCodeLocationAlias());
        logger.alwaysLog("--> Un-map previous Code Locations : " + this.isUnmapPreviousCodeLocations());
        logger.alwaysLog("--> Delete previous Code Locations : " + this.isDeletePreviousCodeLocations());
        logger.alwaysLog("--> Enable Snippet Mode : " + this.isSnippetModeEnabled());
    }

    public String toString() {
        return ReflectionToStringBuilder.toString(this, RecursiveToStringStyle.JSON_STYLE);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, false);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, obj, false);
    }
}

