/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.service;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.api.oauth.Token;
import com.blackducksoftware.integration.hub.request.HubRequest;
import com.blackducksoftware.integration.hub.request.HubRequestFactory;
import com.blackducksoftware.integration.hub.rest.RestConnection;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;

public class HubOAuthTokenService {
    private final Gson gson;
    private final HubRequestFactory hubRequestFactory;

    public HubOAuthTokenService(RestConnection restConnection) {
        this.gson = restConnection.gson;
        this.hubRequestFactory = new HubRequestFactory(restConnection);
    }

    public Token requestUserToken(String clientId, String authCode, String redirectUri) throws IntegrationException {
        return this.requestUserToken(clientId, null, authCode, redirectUri);
    }

    public Token requestUserToken(String clientId, String clientSecret, String authCode, String redirectUri) throws IntegrationException {
        LinkedHashMap<String, String> formDataMap = new LinkedHashMap<String, String>();
        formDataMap.put("grant_type", "authorization_code");
        formDataMap.put("redirect_uri", redirectUri);
        formDataMap.put("client_id", clientId);
        formDataMap.put("code", authCode);
        if (StringUtils.isNotBlank(clientSecret)) {
            formDataMap.put("client_secret", clientSecret);
        }
        return this.getTokenFromEncodedPost(formDataMap);
    }

    public Token refreshClientToken(String clientId) throws IntegrationException {
        return this.refreshClientToken(clientId, null);
    }

    public Token refreshClientToken(String clientId, String clientSecret) throws IntegrationException {
        LinkedHashMap<String, String> formDataMap = new LinkedHashMap<String, String>();
        formDataMap.put("grant_type", "client_credentials");
        formDataMap.put("scope", "read write");
        formDataMap.put("client_id", clientId);
        if (StringUtils.isNotBlank(clientSecret)) {
            formDataMap.put("client_secret", clientSecret);
        }
        return this.getTokenFromEncodedPost(formDataMap);
    }

    public Token refreshUserToken(String clientId, String refreshToken) throws IntegrationException {
        return this.refreshUserToken(clientId, null, refreshToken);
    }

    public Token refreshUserToken(String clientId, String clientSecret, String refreshToken) throws IntegrationException {
        LinkedHashMap<String, String> formDataMap = new LinkedHashMap<String, String>();
        formDataMap.put("grant_type", "refresh_token");
        formDataMap.put("refresh_token", refreshToken);
        formDataMap.put("client_id", clientId);
        if (StringUtils.isNotBlank(clientSecret)) {
            formDataMap.put("client_secret", clientSecret);
        }
        return this.getTokenFromEncodedPost(formDataMap);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Token getTokenFromEncodedPost(Map<String, String> formDataMap) throws IntegrationException {
        HubRequest request = this.hubRequestFactory.createRequest();
        try (Response response = request.executeEncodedFormPost(formDataMap);){
            String jsonToken = response.body().string();
            Token token = this.gson.fromJson(jsonToken, Token.class);
            return token;
        }
        catch (IOException e) {
            throw new IntegrationException(e);
        }
    }
}

