#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#
from com.xebialabs.xlrelease.domain.configuration import HttpConnection
from java.lang import Integer
from org.apache.http.auth import UsernamePasswordCredentials, AuthScope
from org.apache.http.impl.client import BasicCredentialsProvider, HttpClientBuilder, HttpClients
from org.apache.http.protocol import BasicHttpContext
from org.apache.http.util import EntityUtils
from xlrelease.HttpRequest import HttpRequest

from checkmarx.CheckmarxHTTPResponse import CheckmarxHTTPResponse


class CheckmarxHTTPRequest(HttpRequest):

    def __init__(self, params, csrf_token=None, cx_cookie=None):
        self.params = HttpConnection(params)
        self.csrf_token = csrf_token
        self.cx_cookie = cx_cookie

    def setCredentials(self, request):
        if self.cx_cookie:
            request.addHeader('CXCSRFToken', self.csrf_token)
            request.addHeader('cxCookie', self.cx_cookie)
            request.addHeader('Cookie', "CXCSRFToken=" + self.csrf_token + ";cxCookie=" + self.cx_cookie)

    def executeRequest(self, request):
        client = None
        response = None
        try:
            local_context = BasicHttpContext()
            if self.params.proxyUsername and self.params.proxyPassword:
                credentials = UsernamePasswordCredentials(self.params.proxyUsername, self.params.proxyPassword)
                auth_scope = AuthScope(self.params.proxyHost, Integer.valueOf(self.params.proxyPort))
                creds_provider = BasicCredentialsProvider()
                creds_provider.setCredentials(auth_scope, credentials)
                client = HttpClientBuilder.create().setDefaultCredentialsProvider(creds_provider).build()
            else:
                client = HttpClients.createDefault()

            response = client.execute(request, local_context)
            status = response.getStatusLine().getStatusCode()
            entity = response.getEntity()
            result = EntityUtils.toString(entity, "UTF-8") if entity else None
            headers = response.getAllHeaders()
            EntityUtils.consume(entity)

            return CheckmarxHTTPResponse(status, result, headers)
        finally:
            if response:
                response.close()
            if client:
                client.close()
