#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#
import sys

from checkmarx.task import *
from checkmarx.task.helper.risk_profile import *

try:
    validate_mandatory_field(checkmarxServer, "Checkmarx server ID must be provided")
    validate_mandatory_field(team, "Missing value for Team")
    validate_mandatory_field(projectName, "Missing value for Project Name")

    checkmarx_team_id = CheckmarxService.get_team_id_by_name(checkmarx_server=checkmarxServer, team_name=team)

    project_list = CheckmarxService.get_project(checkmarx_server=checkmarxServer, project_name=projectName,
                                                team_id=checkmarx_team_id)
    if project_list:
        checkmarx_project_id = project_list[0]["id"]
    else:
        raise Exception("Could not get project data for : %s" % projectName)

    if not scanId:
        checkmarx_scan_result = CheckmarxService.get_latest_sast_result_stats(checkmarx_server=checkmarxServer,
                                                                              project_id=checkmarx_project_id)
    else:
        checkmarx_scan_status = CheckmarxService.get_scan_status(checkmarx_server=checkmarxServer,
                                                                 scan_id=scanId)

        if checkmarx_scan_status["project"]["id"] != checkmarx_project_id:
            add_comment("Can't retrieve CxSAST Scan result for project {} with scan id {}.".format(projectName, scanId))
            sys.exit(1)

        base_status = get_base_scan_status(scan_status=checkmarx_scan_status["status"]["name"])
        if base_status == BaseStatus.BASE_STATUS_IN_PROGRESS:
            add_comment("CxSAST Scan is in progress for scan id : %s. Can not retrieve result." % scanId)
            sys.exit(1)
        elif base_status == BaseStatus.BASE_STATUS_FAILED:
            add_comment("CxSAST Scan is failed or canceled for scan id : %s. Can not retrieve result." % scanId)
            sys.exit(1)
        else:
            checkmarx_scan_result = CheckmarxService.get_sast_results_stats(checkmarx_server=checkmarxServer,
                                                                            scan_id=scanId)

    risk_high = Risk(checkmarx_scan_result["highSeverity"], securityRiskHighThreshold, "High")
    risk_medium = Risk(checkmarx_scan_result["mediumSeverity"], securityRiskMediumThreshold, "Medium")
    risk_low = Risk(checkmarx_scan_result["lowSeverity"], securityRiskLowThreshold, "Low")

    security_risk_profile = RiskProfile(risk_high, risk_medium, risk_low)
    status = "| Severity       |      Value       |  Threshold    |   Status  | \n"
    status += "|--------------- |:----------------:|:-------------:|:---------:| \n"
    status += risk_high.get_display_text() + "\n"
    status += risk_medium.get_display_text() + "\n"
    status += risk_low.get_display_text() + "\n"
    status += "\n&nbsp;\n"
    print(status)

    if not security_risk_profile.validate():
        add_comment("Issues count is higher than allowed threshold")
        sys.exit(1)

except Exception as e:
    add_comment("Exception occurred: %s " % e)
    sys.exit(1)
