#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#
import urllib

from org.apache.http.client import ClientProtocolException

from checkmarx.CheckmarxHTTPRequest import CheckmarxHTTPRequest

class CheckmarxClient(object):
    def __init__(self, http_connection, csrf_token=None, cx_cookie=None):
        self.http_request = CheckmarxHTTPRequest(http_connection, csrf_token, cx_cookie)
        self.username = http_connection["username"]
        self.password = http_connection["password"]

    @staticmethod
    def create_client(http_connection, csrf_token=None, cx_cookie=None):
        return CheckmarxClient(http_connection, csrf_token, cx_cookie)

    def login(self):
        login_endpoint = "/CxRestAPI/auth/login"

        body = urllib.urlencode({
            "username": str(self.username),
            "password": str(self.password)
        })

        try:
            login_response = self.http_request.post(login_endpoint, body,
                                                    contentType="application/x-www-form-urlencoded")
        except ClientProtocolException:
            raise Exception("URL is not valid")
        if not login_response.isSuccessful():
            reason = "Unknown"
            if login_response.status == 400:
                reason = "Bad request"
            elif login_response.status == 401:
                reason = "Unauthorized"
            elif login_response.status == 403:
                reason = "Forbidden"
            raise Exception("HTTP response code %s (%s)" % (login_response.status, reason))
        return login_response
