#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

import time
import json

uri = "/reporter/api/tests/list?projectName={}".format(projectName)

body = json.dumps(
    {
        "returnTotalCount": True,
        "limit": maxCount,
        "page": 1,
        "sort": [
            {
                "property": "start_time",
                "descending": True
            }
        ]
    }
)

request = HttpRequest(instance)
response = request.post(
    uri, 
    body=body, 
    contentType="application/json"
)

if response.isSuccessful():
    rawData = json.loads(response.getResponse())
else:
    response.errorDump()
    raise Exception("Unable to get data from Experitest")

data = {
    "rawData": rawData["data"],
    "instance": instance["url"],
    "projectName": projectName
}