#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai Software, Inc. and its affiliates, subsidiaries, and licensors.
#

from contextlib import closing

from com.xebialabs.xlrelease.plugin.continuum import JiraPluginConfigurationRequest

from continuum import get_client

global jiraServer
global task
global improve_types
global maintain_types

instance_name = jiraServer["title"]
url = jiraServer["url"]
username = jiraServer["username"]
api_token = jiraServer["password"]
improve_types = ",".join(improve_types)
maintain_types = ",".join(maintain_types)


def sync(client):
    config = JiraPluginConfigurationRequest(
        "jiraplugin",
        instance_name,
        username,
        api_token,
        url,
        improve_types,
        maintain_types,
        None
    )
    return client.configureJiraPlugin(config)


with closing(get_client(task)) as client:
    response = sync(client).Response()
    print "Configured JIRA server {}".format(instance_name)

