#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai Software, Inc. and its affiliates, subsidiaries, and licensors.
#

from com.xebialabs.xlrelease.plugin.continuum import NewRevisionRequest
from contextlib import closing

from continuum import get_client

global task

global package


def new_revision(client):
    global version
    global full_version

    if version == "":
        version = None

    if full_version == "":
        full_version = None

    res = client.newRevision(NewRevisionRequest(
        package,
        version,
        full_version
    ))
    return res


with closing(get_client(task)) as client:
    response = new_revision(client).Response()
    print "Created a new revision for {}".format(package)
