#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai Software, Inc. and its affiliates, subsidiaries, and licensors.
#

from contextlib import closing

from continuum import get_client

global task
global pipeline_instance_id
global pipeline_status
global definition
global continuumServer


def pipeline_link(server_url, pipeline_definition, pipeline_instance_id):
    pipeline_title = "{} ({})".format(pipeline_definition, pipeline_instance_id)
    pipeline_url = "{}/flow/pi_detail?id={}".format(server_url.rstrip("/"), pipeline_instance_id)
    return "[{}]({})".format(pipeline_title, pipeline_url)


with closing(get_client(task)) as client:
    resp = client.getPipelineInstance(pipeline_instance_id).Response()
    instance_status = resp.get("status", "")
    task.setStatusLine("Status: {}.".format(instance_status))
    if instance_status not in ["success", "failure", "canceled"]:
        task.schedule("continuum/RunAPipeline.wait.py")
    else:
        pipeline_status = instance_status
        response = resp
        pipeline_md = pipeline_link(continuumServer["url"], definition, pipeline_instance_id)
        print "Pipeline {} has ended with status: {}".format(pipeline_md, pipeline_status)
        # If we have to fail a task when pipeline fails uncomment following lines:
        # if instance_status in ["failure", "canceled"]:
        #     sys.exit(1)  # fail the task
