#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai Software, Inc. and its affiliates, subsidiaries, and licensors.
#

from contextlib import closing

from com.xebialabs.xlrelease.plugin.continuum import GithubPluginConfigurationRequest
from continuum import get_client

global githubServer
global task

if str(githubServer["authenticationMethod"]) != "PAT":
    raise ValueError("Authentication method is not PAT")

instance_name = githubServer["title"]
url = githubServer["url"]
username = githubServer["username"]
token = githubServer["password"]


with closing(get_client(task)) as client:
    config = GithubPluginConfigurationRequest(
        "github",
        instance_name,
        username,
        url,
        token
    )
    response = client.configureGithubPlugin(config).Response()
    print "Configured GitHub server {}".format(instance_name)

