package com.xebialabs.xlrelease.plugins.dashboard.api.internal

import javax.ws.rs._
import javax.ws.rs.core.MediaType

import com.xebialabs.deployit.repository.RepositoryService
import com.xebialabs.xlrelease.plugins.dashboard.repository.Dashboards
import com.xebialabs.xlrelease.plugins.dashboard.views.DashboardView
import com.xebialabs.xlrelease.plugins.dashboard.views.DashboardView.toDashboard
import com.xebialabs.xlrelease.repository.Ids.releaseIdFrom
import com.xebialabs.xlrelease.security.PermissionChecker
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Controller

@Path("/dashboards")
@Controller
class DashboardResource @Autowired()(val dashboards: Dashboards,
                                     val permissionChecker: PermissionChecker,
                                     implicit val repositoryService: RepositoryService) {
  @GET
  @Path("{dashboardId:.+}")
  @Produces(Array(MediaType.APPLICATION_JSON))
  def getDashboard(@PathParam("dashboardId") dashboardId: String): DashboardView = {
    permissionChecker.checkView(releaseIdFrom(dashboardId))
    new DashboardView(dashboards.findByIdOrDefault(dashboardId))
  }

  @PUT
  @Path("{dashboardId:.*}")
  @Produces(Array(MediaType.APPLICATION_JSON))
  @Consumes(Array(MediaType.APPLICATION_JSON))
  def updateDashboard(@PathParam("dashboardId") dashboardId: String, dashboard: DashboardView): DashboardView = {
    permissionChecker.checkEdit(releaseIdFrom(dashboardId))
    dashboard.id = dashboardId
    val updatedDashboard = dashboards.createOrUpdateDashboard(toDashboard(dashboard))
    DashboardView(updatedDashboard)
  }

}