package com.xebialabs.xlrelease.plugins.dashboard.service

import com.google.common.base.Preconditions.checkState
import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.plugins.dashboard.domain.Tile
import com.xebialabs.xlrelease.variable.VariableResolver._

import scala.collection.convert.wrapAll._

object TileHelper {
  def resolveVariables(tile: Tile, release: Release): Tile = {
    checkState(release.getGlobalVariables != null, "Release [%s] not initialized with global variables, please check VariableService.decorateWithGlobalVariables has been invoked.", release.getId)
    val (unresolved, _) = resolve(tile, release.getVariables ++ release.getGlobalVariables.getVariables ++ release.getCiPropertyVariables)
    if (unresolved.nonEmpty) {
      throw new IllegalArgumentException(String.format(
        "Unable to fetch data for tile '%s' due to missing values for variables: %s", tile.getTitle, unresolved.mkString(", ")))
    }
    tile
  }
}
