package com.xebialabs.xlrelease.plugins.dashboard.service

import com.xebialabs.xlrelease.plugins.dashboard.domain.Tile
import com.xebialabs.xlrelease.plugins.dashboard.repository.Dashboards
import com.xebialabs.xlrelease.plugins.dashboard.service.TileHelper.resolveVariables
import com.xebialabs.xlrelease.repository.{Ids, Releases}
import com.xebialabs.xlrelease.service.VariableService
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

@Service
class TileService @Autowired()(releases: Releases, dashboards: Dashboards,
                               variableService: VariableService, tileScriptExecutor: TileScriptExecutor) extends Logging {

  val cacheBusterKey = "cb"
  val refreshKey = "refresh"

  def executeTileDataScript(tileId: String, additionalVariables: Map[String, Any]): Any = {
    val release = releases.findByIdIncludingArchived(Ids.releaseIdFrom(tileId))
    variableService.decorateWithGlobalVariables(release)
    val tile = dashboards.findTileById(tileId)
    val resolvedTile: Tile = resolveVariables(tile, release)

    val variablesWithoutCacheBuster = additionalVariables - cacheBusterKey - refreshKey
    if (additionalVariables.contains(refreshKey)) {
      tileScriptExecutor.evictFromCache(release, resolvedTile, variablesWithoutCacheBuster)
    }
    tileScriptExecutor.executeTileScript(release, resolvedTile, variablesWithoutCacheBuster)
  }

}
