'use strict';

(function () {

    var XlrDefaultTileController = function XlrDefaultTileController($scope, XlrDefaultTileService) {
        var tile;
        var vm = this;
        vm.data = null;
        vm.release = $scope.release;
        if ($scope.xlrTile) {
            // summary mode
            tile = $scope.xlrTile.tile;
        } else {
            // details mode
            tile = $scope.xlrTileDetailsCtrl.tile;
        }
        function load() {
            vm.loading = true;
            // Optional query for getting data from an external backend, for example Jira or Jenkins
            XlrDefaultTileService.executeQuery(tile.id).then(function (response) {
                vm.data = response.data.data;
            }).finally(function () {
                vm.loading = false;
            });
        }
        load();
        vm.refresh = load;
    };

    XlrDefaultTileController.$inject = ['$scope', 'xlrelease.dashboard.XlrDefaultTileService'];

    var XlrDefaultTileService = function XlrDefaultTileService(Backend) {
        function executeQuery(tileId) {
            // This will trigger a Jython script (TileType.py by default) to get data from the external source.
            // The script can access input properties.
            // Query parameters can also be used here and will be available as variables in the script.
            return Backend.get('tiles/' + tileId + '/data');
        }
        return {
            executeQuery: executeQuery
        };
    };

    XlrDefaultTileService.$inject = ['Backend'];

    angular.module('xlrelease.dashboard').service('xlrelease.dashboard.XlrDefaultTileService', XlrDefaultTileService);
    angular.module('xlrelease.dashboard').controller('xlrelease.dashboard.XlrDefaultTileController', XlrDefaultTileController);
})();