package com.xebialabs.xlrelease.plugins.dashboard.cache

import java.lang.reflect.Method

import com.xebialabs.deployit.plugin.api.reflect.{PropertyDescriptor, PropertyKind}
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import com.xebialabs.xlrelease.plugins.dashboard.domain.Tile
import com.xebialabs.xlrelease.user.User
import grizzled.slf4j.Logging
import org.springframework.cache.interceptor.{KeyGenerator, SimpleKey}

import scala.collection.JavaConversions._
import scala.collection.immutable.ListMap

class TileCacheKeyGenerator extends KeyGenerator with Logging {

  val separator = "|"
  val userSpecificCache = "userSpecificCache"
  val id = "id"

  override def generate(target: Any, method: Method, params: AnyRef*): AnyRef = {
    val valuesForKey: Seq[String] = params.map {
      case map: Map[_,_] => map.mkString(separator)
      case tile: Tile =>
        val configurationProps: Map[String, Any] = tile.getConfigurationProperties
          .map(descriptor =>  {
            val propertyValue: Any = tile.getProperty(descriptor.getName)
            val token = fetchToken(descriptor, propertyValue)
            descriptor.getName -> (propertyValue + token)
          })
          .toMap
        val props: Map[String, Any] = if (tile.isUserSpecificCache)
          Map(id -> tile.getId, userSpecificCache -> User.AUTHENTICATED_USER.getName) ++ configurationProps
        else
          Map(id -> tile.getId) ++ configurationProps
        ListMap(props.toSeq.sortBy(_._1):_*).mkString(separator)
      case _ => ""
    }

    val key = new SimpleKey(valuesForKey.filterNot(_.isEmpty).mkString(separator))
    logger.debug(s"Generated key with hashcode: ${key.hashCode}, key: $key")
    key
  }

  private def fetchToken(descriptor: PropertyDescriptor, propertyValue: Any): String = {
    if (null != propertyValue && descriptor.getKind == PropertyKind.CI) {
      Option(propertyValue.asInstanceOf[BaseConfigurationItem].get$token()).getOrElse("")
    } else ""
  }
}
