package com.xebialabs.xlrelease.plugins.dashboard.domain;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.ReleaseExtension;

import static com.google.common.collect.Maps.newHashMap;
import static com.xebialabs.xlrelease.domain.Task.CATEGORY_INPUT;
import static java.util.stream.Collectors.toList;

/**
 * Base class for dashboard tiles, for example tiles of the "Release contents" page.
 */
@Metadata(virtual = true, versioned = false, description = "Base type for dashboard tiles")
public class Tile extends ReleaseExtension {
    public static final String PROPERTY_USER_SPECIFIC_CACHE = "userSpecificCache";
    public static final String PROPERTY_EXPIRATION_TIME = "expirationTime";
    public static final String PROPERTY_MAX_CACHE_ENTRIES = "maxCacheEntries";

    @Property(category = CATEGORY_INPUT, description = "Title of this tile")
    private String title;

    @Property(required = true, hidden = true, description = "URI of the HTML file to render the summary mode of this tile")
    private String uri;

    @Property(required = false, hidden = true, description = "URI pointing to the HTML file to render when we are switching to details view")
    private String detailsUri;

    @Property(required = false, hidden = true, description = "URI of the HTML file to render the configuration mode of this tile")
    private String configurationUri;

    @Property(required = false, hidden = true, description = "Dashboards that contain this tile by default")
    private List<String> defaultDashboards = new ArrayList<>();

    @Property(required = false, hidden = true, description = "Optional custom classpath location of the tile Jython script")
    private String scriptLocation;

    // The gridConfiguration properties get their defaults on UI side, so they have to be null by default
    @Property(category = "gridConfiguration", description = "Default width of this tile in number of dashboard columns it occupies")
    private Integer width;
    @Property(category = "gridConfiguration", description = "Row number of this tile on the dashboard")
    private Integer row;
    @Property(category = "gridConfiguration", description = "Column number of this tile on the dashboard")
    private Integer col;

    @Property(category = "cache", required = false, hidden = true, defaultValue = "true", description = "True if tile data should be cached")
    private boolean cacheEnabled = true;

    @Property(category = "cache", required = false, hidden = true, description = "True if tile data should be cached per user.")
    private boolean userSpecificCache = false;

    @Property(category = "cache", required = false, hidden = true, defaultValue = "300", description = "Expiration time for a tile cache (in seconds).")
    private Integer expirationTime = 5 * 60;

    @Property(category = "cache", required = false, hidden = true, defaultValue = "500", description = "Maximum cache entries.")
    private Integer maxCacheEntries = 500;

    @Property()
    private Map<String, String> variableMapping = newHashMap();

    @Override
    public List<PropertyDescriptor> getScannableProperties() {
        return getConfigurationProperties();
    }

    public List<PropertyDescriptor> getConfigurationProperties() {
        return this.getType().getDescriptor().getPropertyDescriptors()
                .stream()
                .filter(pd -> CATEGORY_INPUT.equals(pd.getCategory()))
                .collect(toList());
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(final String title) {
        this.title = title;
    }

    public String getUri() {
        return uri;
    }

    public void setUri(final String uri) {
        this.uri = uri;
    }

    public String getDetailsUri() {
        return detailsUri;
    }

    public void setDetailsUri(final String detailsUri) {
        this.detailsUri = detailsUri;
    }

    public String getConfigurationUri() {
        return configurationUri;
    }

    public void setConfigurationUri(final String configurationUri) {
        this.configurationUri = configurationUri;
    }

    public List<String> getDefaultDashboards() {
        return defaultDashboards;
    }

    public Integer getWidth() {
        return width;
    }

    public void setWidth(final Integer width) {
        this.width = width;
    }

    public Integer getRow() {
        return row;
    }

    public void setRow(final Integer row) {
        this.row = row;
    }

    public Integer getCol() {
        return col;
    }

    public void setCol(final Integer col) {
        this.col = col;
    }

    public Map<String, String> getVariableMapping() {
        return variableMapping;
    }

    public void setVariableMapping(Map<String, String> variableMapping) {
        this.variableMapping = variableMapping;
    }

    public boolean isCacheEnabled() {
        return cacheEnabled;
    }

    public void setCacheEnabled(final boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    public boolean isUserSpecificCache() {
        return userSpecificCache;
    }

    public void setUserSpecificCache(final boolean userSpecificCache) {
        this.userSpecificCache = userSpecificCache;
    }

    public Integer getExpirationTime() {
        return expirationTime;
    }

    public void setExpirationTime(final Integer expirationTime) {
        this.expirationTime = expirationTime;
    }

    public Integer getMaxCacheEntries() {
        return maxCacheEntries;
    }

    public void setMaxCacheEntries(final Integer maxCacheEntries) {
        this.maxCacheEntries = maxCacheEntries;
    }

    public String getScriptLocation() {
        return scriptLocation;
    }
}
