package com.xebialabs.xlrelease.plugins.dashboard.views

import java.util.{List => JList}

import com.xebialabs.deployit.repository.RepositoryService
import com.xebialabs.xlrelease.plugins.dashboard.builder.DashboardBuilder.newDashboard
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard
import com.xebialabs.xlrelease.plugins.dashboard.views.TileView.toTile
import org.codehaus.jackson.annotate.JsonIgnoreProperties

import scala.beans.BeanProperty
import scala.collection.JavaConversions._

object DashboardView {
  def apply(dashboard: Dashboard) = new DashboardView(dashboard)

  def toDashboard(dashboardView: DashboardView)(implicit repositoryService: RepositoryService) = newDashboard
    .withId(dashboardView.getId)
    .withTiles(dashboardView.getTiles.map(toTile): _*)
    .build
}

@JsonIgnoreProperties(ignoreUnknown = true)
class DashboardView(val dashboard: Dashboard) {

  @BeanProperty
  var id: String = dashboard.getId

  @BeanProperty
  var tiles: JList[TileView] = dashboard.getTiles.map(TileView.apply)

  def this() {
    this(newDashboard.build)
  }
}
