#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import sys
import urllib2
import base64
import com.xebialabs.xlrelease.plugin.dockercompose.RemoteScript as RemoteScript

class APIClient:

    def __init__(self, host, dockercompose_path, cmd_params, project_name):
        self.remote = RemoteScript(host)
        self.base_command = dockercompose_path
        self.cmd_params = "-p %s %s" % (project_name, cmd_params if cmd_params else '')

    def execute_dockercompose(self, yaml, sub_command):
        response = self.remote.executeDockerCompose(yaml, self.base_command, self.cmd_params, sub_command)
        APIClient.print_logs(response)
        return response

    def execute_command(self, command):
        response = self.remote.executeScript(command)
        APIClient.print_logs(response)
        return response

    @staticmethod
    def download_file(url, username, password):
        request=urllib2.Request(url)
        if (username is not None) and (password is not None):
            base64string = base64.encodestring('%s:%s' % (username, password))[:-1]
            auth_header =  "Basic %s" % base64string
            request.add_header("Authorization", auth_header)

        return urllib2.urlopen(request).read()

    @staticmethod
    def print_logs(response):
        if response.rc == 0:
            print "```"
            print response.stdout
            print "```"
        else:
            print "Exit code: "
            print response.rc
            print
            print "#### Output:"
            print "```"
            print response.stdout
            print "```"

            print "----"
            print "#### Error stream:"
            print "```"
            print response.stderr
            print "```"
            print

            sys.exit(response.rc)
