/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.runner.docker.actors;

import com.xebialabs.xlrelease.storage.domain.LogEntry;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.Instant;
import org.apache.commons.io.output.ByteArrayOutputStream;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015d\u0001B\u000f\u001f\u0001-B\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!A!\u000b\u0001B\u0001B\u0003%1\u000bC\u0003W\u0001\u0011\u0005q\u000bC\u0004^\u0001\u0001\u0007I\u0011\u00020\t\u000f}\u0003\u0001\u0019!C\u0005A\"1a\r\u0001Q!\nMCqa\u001a\u0001A\u0002\u0013%\u0001\u000eC\u0004m\u0001\u0001\u0007I\u0011B7\t\r=\u0004\u0001\u0015)\u0003j\u0011\u001d\u0001\bA1A\u0005\u000e!Da!\u001d\u0001!\u0002\u001bI\u0007b\u0002:\u0001\u0005\u0004%Ia\u001d\u0005\b\u0003\u000b\u0001\u0001\u0015!\u0003u\u0011%\t9\u0001\u0001b\u0001\n\u0013\tI\u0001\u0003\u0005\u0002\u001a\u0001\u0001\u000b\u0011BA\u0006\u0011!\tY\u0002\u0001a\u0001\n\u0013q\u0006\"CA\u000f\u0001\u0001\u0007I\u0011BA\u0010\u0011\u001d\t\u0019\u0003\u0001Q!\nMC\u0001\"!\n\u0001\u0001\u0004%IA\u0018\u0005\n\u0003O\u0001\u0001\u0019!C\u0005\u0003SAq!!\f\u0001A\u0003&1\u000bC\u0004\u00020\u0001!\t!!\r\t\r\u0005]\u0003\u0001\"\u0001_\u0011\u0019\tI\u0006\u0001C\u0001=\"9\u00111\f\u0001\u0005\u0002\u0005u\u0003bBA0\u0001\u0011\u0005\u0011\u0011\r\u0005\b\u0003G\u0002A\u0011BA/\u0005=!unY6fe2{w\rS3ma\u0016\u0014(BA\u0010!\u0003\u0019\t7\r^8sg*\u0011\u0011EI\u0001\u0007I>\u001c7.\u001a:\u000b\u0005\r\"\u0013A\u0002:v]:,'O\u0003\u0002&M\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003O!\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003%\n1aY8n\u0007\u0001\u0019\"\u0001\u0001\u0017\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0003=\nQa]2bY\u0006L!!\r\u0018\u0003\r\u0005s\u0017PU3g\u0003\u0019!\u0018m]6JIB\u0011Ag\u000f\b\u0003ke\u0002\"A\u000e\u0018\u000e\u0003]R!\u0001\u000f\u0016\u0002\rq\u0012xn\u001c;?\u0013\tQd&\u0001\u0004Qe\u0016$WMZ\u0005\u0003yu\u0012aa\u0015;sS:<'B\u0001\u001e/\u0003\u0015QwNY%e!\t\u0001uJ\u0004\u0002B\u0019:\u0011!I\u0013\b\u0003\u0007&s!\u0001\u0012%\u000f\u0005\u0015;eB\u0001\u001cG\u0013\u0005I\u0013BA\u0014)\u0013\t)c%\u0003\u0002$I%\u00111JI\u0001\u0007I>l\u0017-\u001b8\n\u00055s\u0015a\u00029bG.\fw-\u001a\u0006\u0003\u0017\nJ!\u0001U)\u0003\u000b){'-\u00133\u000b\u00055s\u0015!\u00037bgR\u001c\u0005.\u001e8l!\tiC+\u0003\u0002V]\t!Aj\u001c8h\u0003\u0019a\u0014N\\5u}Q!\u0001LW.]!\tI\u0006!D\u0001\u001f\u0011\u0015\u0011D\u00011\u00014\u0011\u0015qD\u00011\u0001@\u0011\u0015\u0011F\u00011\u0001T\u00031\u0019WO\u001d:f]R\u001c\u0005.\u001e8l+\u0005\u0019\u0016\u0001E2veJ,g\u000e^\"ik:\\w\fJ3r)\t\tG\r\u0005\u0002.E&\u00111M\f\u0002\u0005+:LG\u000fC\u0004f\r\u0005\u0005\t\u0019A*\u0002\u0007a$\u0013'A\u0007dkJ\u0014XM\u001c;DQVt7\u000eI\u0001\u0012GV\u0014(/\u001a8u\u0005V4g-\u001a:TSj,W#A5\u0011\u00055R\u0017BA6/\u0005\rIe\u000e^\u0001\u0016GV\u0014(/\u001a8u\u0005V4g-\u001a:TSj,w\fJ3r)\t\tg\u000eC\u0004f\u0013\u0005\u0005\t\u0019A5\u0002%\r,(O]3oi\n+hMZ3s'&TX\rI\u0001\u000bEV4g-\u001a:TSj,\u0017a\u00032vM\u001a,'oU5{K\u0002\nQCY=uK\u0006\u0013(/Y=PkR\u0004X\u000f^*ue\u0016\fW.F\u0001u!\r)\u0018\u0011A\u0007\u0002m*\u0011q\u000f_\u0001\u0007_V$\b/\u001e;\u000b\u0005eT\u0018AA5p\u0015\tYH0A\u0004d_6lwN\\:\u000b\u0005ut\u0018AB1qC\u000eDWMC\u0001\u0000\u0003\ry'oZ\u0005\u0004\u0003\u00071(!\u0006\"zi\u0016\f%O]1z\u001fV$\b/\u001e;TiJ,\u0017-\\\u0001\u0017Ef$X-\u0011:sCf|U\u000f\u001e9viN#(/Z1nA\u0005aq.\u001e;qkR\u001cFO]3b[V\u0011\u00111\u0002\t\u0005\u0003\u001b\t)\"\u0004\u0002\u0002\u0010)\u0019\u00110!\u0005\u000b\u0005\u0005M\u0011\u0001\u00026bm\u0006LA!a\u0006\u0002\u0010\t!\")\u001e4gKJ,GmT;uaV$8\u000b\u001e:fC6\fQb\\;uaV$8\u000b\u001e:fC6\u0004\u0013\u0001\u00057bgRdun\u001a+j[\u0016\u001cH/Y7q\u0003Qa\u0017m\u001d;M_\u001e$\u0016.\\3ti\u0006l\u0007o\u0018\u0013fcR\u0019\u0011-!\t\t\u000f\u0015\u0014\u0012\u0011!a\u0001'\u0006\tB.Y:u\u0019><G+[7fgR\fW\u000e\u001d\u0011\u0002%1\f7\u000f\u001e$mkNDG+[7fgR\fW\u000e]\u0001\u0017Y\u0006\u001cHO\u00127vg\"$\u0016.\\3ti\u0006l\u0007o\u0018\u0013fcR\u0019\u0011-a\u000b\t\u000f\u0015,\u0012\u0011!a\u0001'\u0006\u0019B.Y:u\r2,8\u000f\u001b+j[\u0016\u001cH/Y7qA\u0005Y\u0011\r\u001d9f]\u0012,e\u000e\u001e:z)\u0011\t\u0019$a\u0012\u0011\u000b5\n)$!\u000f\n\u0007\u0005]bF\u0001\u0004PaRLwN\u001c\t\u0005\u0003w\t\u0019%\u0004\u0002\u0002>)\u00191*a\u0010\u000b\u0007\u0005\u0005C%A\u0004ti>\u0014\u0018mZ3\n\t\u0005\u0015\u0013Q\b\u0002\t\u0019><WI\u001c;ss\"9\u0011\u0011J\fA\u0002\u0005-\u0013a\u00029bs2|\u0017\r\u001a\t\u0006[\u00055\u0013\u0011K\u0005\u0004\u0003\u001fr#!B!se\u0006L\bcA\u0017\u0002T%\u0019\u0011Q\u000b\u0018\u0003\t\tKH/Z\u0001\u0010O\u0016$8)\u001e:sK:$8\t[;oW\u0006\u0019r-\u001a;MCN$Hj\\4US6,7\u000f^1na\u0006)a\r\\;tQR\u0011\u0011\u0011H\u0001\u0006G2|7/\u001a\u000b\u0002C\u0006Ya\r\\;tQ\n+hMZ3s\u0001")
public class DockerLogHelper {
    private final String taskId;
    private final long jobId;
    private long currentChunk;
    private int currentBufferSize;
    private final int bufferSize;
    private final ByteArrayOutputStream byteArrayOutputStream;
    private final BufferedOutputStream outputStream;
    private long lastLogTimestamp;
    private long lastFlushTimestamp;

    private long currentChunk() {
        return this.currentChunk;
    }

    private void currentChunk_$eq(long x$1) {
        this.currentChunk = x$1;
    }

    private int currentBufferSize() {
        return this.currentBufferSize;
    }

    private void currentBufferSize_$eq(int x$1) {
        this.currentBufferSize = x$1;
    }

    private final int bufferSize() {
        return this.bufferSize;
    }

    private ByteArrayOutputStream byteArrayOutputStream() {
        return this.byteArrayOutputStream;
    }

    private BufferedOutputStream outputStream() {
        return this.outputStream;
    }

    private long lastLogTimestamp() {
        return this.lastLogTimestamp;
    }

    private void lastLogTimestamp_$eq(long x$1) {
        this.lastLogTimestamp = x$1;
    }

    private long lastFlushTimestamp() {
        return this.lastFlushTimestamp;
    }

    private void lastFlushTimestamp_$eq(long x$1) {
        this.lastFlushTimestamp = x$1;
    }

    public Option<LogEntry> appendEntry(byte[] payload) {
        this.lastLogTimestamp_$eq(Instant.now().getEpochSecond());
        this.outputStream().write(payload);
        this.currentBufferSize_$eq(this.currentBufferSize() + payload.length);
        FiniteDuration durationSinceLastFlush = new package.DurationLong(package$.MODULE$.DurationLong(this.lastLogTimestamp() - this.lastFlushTimestamp())).seconds();
        return this.currentBufferSize() > this.bufferSize() || durationSinceLastFlush.$greater$eq((Object)new package.DurationLong(package$.MODULE$.DurationLong(2L)).seconds()) ? new Some((Object)this.flushBuffer()) : None$.MODULE$;
    }

    public long getCurrentChunk() {
        return this.currentChunk();
    }

    public long getLastLogTimestamp() {
        return this.lastLogTimestamp();
    }

    public LogEntry flush() {
        this.lastLogTimestamp_$eq(Instant.now().getEpochSecond());
        return this.flushBuffer();
    }

    public void close() {
        Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.outputStream().close());
        Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.byteArrayOutputStream().close());
    }

    private LogEntry flushBuffer() {
        this.currentChunk_$eq(this.currentChunk() + 1L);
        this.outputStream().flush();
        byte[] currentBuffer = this.byteArrayOutputStream().toByteArray();
        this.byteArrayOutputStream().reset();
        this.currentBufferSize_$eq(0);
        this.lastFlushTimestamp_$eq(Instant.now().getEpochSecond());
        return new LogEntry(this.taskId, this.jobId, this.currentChunk(), this.lastLogTimestamp(), currentBuffer, "xlr-local");
    }

    public DockerLogHelper(String taskId, long jobId, long lastChunk) {
        this.taskId = taskId;
        this.jobId = jobId;
        this.currentChunk = lastChunk;
        this.currentBufferSize = 0;
        this.bufferSize = 8192;
        this.byteArrayOutputStream = new ByteArrayOutputStream(this.bufferSize() * 2);
        this.outputStream = new BufferedOutputStream((OutputStream)this.byteArrayOutputStream(), this.bufferSize());
        this.lastLogTimestamp = Instant.now().getEpochSecond();
        this.lastFlushTimestamp = this.lastLogTimestamp();
    }
}

