package com.xebialabs.xlrelease.runner.docker.actors

import akka.actor.{Actor, ActorInitializationException, ActorLogging, ActorRef, DeathPactException, OneForOneStrategy, SupervisorStrategy}
import com.xebialabs.xlrelease.runner.docker.actors.DockerJobExecutorActor.{DockerJobCommand, actorName}
import com.xebialabs.xlrelease.runner.domain.JobId
import com.xebialabs.xlrelease.support.akka.spring.{SpringActor, SpringExtension}

@SpringActor
class DockerJobExecutorProcessingActor extends Actor with ActorLogging {

  def createOrFind(jobId: JobId, msg: AnyRef): ActorRef = {
    context.child(actorName(jobId)).getOrElse {
      log.debug(s"DockerJobExecutorProcessingActor - creating an actor tree for $jobId (triggered by $msg)")
      SpringExtension.childActorOf(classOf[DockerJobExecutorActor], actorName(jobId))(context)
    }
  }

  override def receive: Receive = {
    case cmd: DockerJobCommand =>
      log.debug(s"Received $cmd")
      createOrFind(cmd.jobId, cmd) forward cmd
    case msg =>
      log.error(s"Can't process $msg")
  }

  override val supervisorStrategy = OneForOneStrategy() {
    case _: ActorInitializationException => SupervisorStrategy.Stop
    case _: DeathPactException => SupervisorStrategy.Stop
    case _: DockerExecutorIllegalState => SupervisorStrategy.Stop
    case _: DockerConnectException => SupervisorStrategy.Stop
    case _: Exception => SupervisorStrategy.Restart
  }

}
