#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#

import org.apache.http.conn.HttpHostConnectException

from fortifyOnDemand import FortifyOnDemandService

if not fortifyOnDemandServer:
    raise Exception("Fortify server ID must be provided")
try:
    data = {'projectName': projectName, 'projectVersion': projectVersion, 'fortifyUrl': fortifyOnDemandServer['url'].replace('api.','')}

    application_data = FortifyOnDemandService.get_application_data(fortifyOnDemandServer, application_name=projectName)

    total_count = application_data["totalCount"]
    items = application_data["items"]
    metrics = {"rating": "Security Rating", "issueCount": "Total Issues", "critical": "Critical Issues",
               "high": "High Issues", "medium": "Medium Issues", "low": "Low Issues"}

    if total_count > 0 and items[0]["applicationName"] == projectName:
        data["applicationId"] = items[0]["applicationId"]
        release_rating_data = FortifyOnDemandService.get_release_ratings(fortifyOnDemandServer,
                                                                         application_id=items[0]["applicationId"],
                                                                         release_name=projectVersion)
        release_total_count = release_rating_data["totalCount"]
        release_items = release_rating_data["items"]

        if release_total_count > 0 and release_items[0]["releaseName"] == projectVersion:
            data["releaseId"] = release_items[0]["releaseId"]
            if release_items[0]["staticScanDate"] is not None:
                data["staticScanDate"] = release_items[0]["staticScanDate"]
            if release_items[0]["dynamicScanDate"] is not None:
                data["dynamicScanDate"] = release_items[0]["dynamicScanDate"]
            if release_items[0]["mobileScanDate"] is not None:
                data["mobileScanDate"] = release_items[0]["mobileScanDate"]

            for item in metrics.keys():
                data[item] = release_items[0][item] if item in release_items[0].keys() else '-'
        else:
            error_message = "Failed to get release data. Please verify Release Name : %s on server." % projectVersion
            raise Exception(error_message)
    else:
        error_message = "Failed to get application data. Please verify Application Name : %s on server." % projectName
        raise Exception(error_message)

except org.apache.http.conn.HttpHostConnectException as e:
    print "Connection Failed: {0} ".format(str(e))
    data = {'error': [{'msg': e.getMessage()}]}

except Exception as e:
    print "Exception occurred: {0} ".format(str(e))
    data = {'error': [{'msg': str(e)}]}
