import json
import time

global map
global CI
global input
global config

def parseDate(date):
    if (isinstance(date, int)):
        return time.strftime('%Y-%m-%dT%H:%M:%S', time.localtime(date))
    else:
        return date

def parse_BranchRef(data):
    if data:
        return CI("github.BranchRef", {
            'label': data['label'] if 'label' in data else None,
            'ref': data['ref'] if 'ref' in data else None,
            'sha': data['sha'] if 'sha' in data else None,
            'repo': parse_Repository(data['repo'] if 'repo' in data else None),
            'user': parse_User(data['user'] if 'user' in data else None)
        })
    else:
        return None

def parse_Milestone(data):
    if data:
        return CI("github.Milestone", {
            'url': data.get('url', None),
            'html_url': data.get('html_url', None),
            'labels_url': data.get('labels_url', None),
            '_id': data.get('id', None),
            'node_id': data.get('node_id', None),
            'number': data.get('number', None),
            'title': data.get('title', None),
            'description': data.get('description', None),
            'creator': parse_User(data.get('creator', None)),
            'open_issues': data.get('open_issues', None),
            'closed_issues': data.get('closed_issues', None),
            'state': data.get('state', None),
            'created_at': parseDate(data.get('created_at', None)),
            'updated_at': parseDate(data.get('updated_at', None)),
            'due_on': parseDate(data.get('due_on', None)),
            'closed_at': parseDate(data.get('closed_at', None))
        })
    else:
        return None

def parse_PullRequest(data):
    if data:
        return CI("github.PullRequest", {
            'number': data['number'] if 'number' in data else None,
            'statuses_url': data['statuses_url'] if 'statuses_url' in data else None,
            'body': data['body'] if 'body' in data else None,
            'additions': data['additions'] if 'additions' in data else None,
            'changed_files': data['changed_files'] if 'changed_files' in data else None,
            'requested_teams': data['requested_teams'] if 'requested_teams' in data else None,
            'state': data['state'] if 'state' in data else None,
            'url': data['url'] if 'url' in data else None,
            'issue_url': data['issue_url'] if 'issue_url' in data else None,
            'maintainer_can_modify': data['maintainer_can_modify'] if 'maintainer_can_modify' in data else None,
            '_id': data['id'] if 'id' in data else None,
            'head': parse_BranchRef(data['head'] if 'head' in data else None),
            'node_id': data['node_id'] if 'node_id' in data else None,
            'mergeable_state': data['mergeable_state'] if 'mergeable_state' in data else None,
            'merged_by': parse_User(data['merged_by'] if 'merged_by' in data else None),
            'merged_at': parseDate(data['merged_at'] if 'merged_at' in data else None),
            'merge_commit_sha': data['merge_commit_sha'] if 'merge_commit_sha' in data else None,
            'mergeable': data['mergeable'] if 'mergeable' in data else None,
            'rebaseable': data['rebaseable'] if 'rebaseable' in data else None,
            'milestone': parse_Milestone(data['milestone'] if 'milestone' in data else None),
            'review_comments': data['review_comments'] if 'review_comments' in data else None,
            'merged': data['merged'] if 'merged' in data else None,
            'draft': data['draft'] if 'draft' in data else None,
            'commits': data['commits'] if 'commits' in data else None,
            'locked': data['locked'] if 'locked' in data else None,
            'patch_url': data['patch_url'] if 'patch_url' in data else None,
            'commits_url': data['commits_url'] if 'commits_url' in data else None,
            'review_comments_url': data['review_comments_url'] if 'review_comments_url' in data else None,
            'base': parse_BranchRef(data['base'] if 'base' in data else None),
            'review_comment_url': data['review_comment_url'] if 'review_comment_url' in data else None,
            'assignee': parse_User(data['assignee'] if 'assignee' in data else None),
            'assignees': map(lambda x: parse_User(x), data['assignees'] if 'assignees' in data else None),
            'comments_url': data['comments_url'] if 'comments_url' in data else None,
            'labels': map(lambda x: parse_Label(x), data['labels'] if 'labels' in data else None),
            'labels_names': map(lambda x: x['name'], data['labels'] if 'labels' in data else []),
            'requested_reviewers': map(lambda x: parse_User(x), data['requested_reviewers'] if 'requested_reviewers' in data else None),
            'created_at': parseDate(data['created_at'] if 'created_at' in data else None),
            'title': data['title'] if 'title' in data else None,
            'html_url': data['html_url'] if 'html_url' in data else None,
            'author_association': data['author_association'] if 'author_association' in data else None,
            'deletions': data['deletions'] if 'deletions' in data else None,
            'updated_at': parseDate(data['updated_at'] if 'updated_at' in data else None),
            'diff_url': data['diff_url'] if 'diff_url' in data else None,
            'user': parse_User(data['user'] if 'user' in data else None),
            'comments': data['comments'] if 'comments' in data else None,
            '_links': parse_Links(data['_links'] if '_links' in data else None)
        })
    else:
        return None

def parse_Label(data):
    if data:
        return CI("github.Label", {
            '_id': data['id'] if 'id' in data else None,
            'node_id': data['node_id'] if 'node_id' in data else None,
            'url': data['url'] if 'url' in data else None,
            '_name': data['name'] if 'name' in data else None,
            'color': data['color'] if 'color' in data else None,
            'default': data['default'] if 'default' in data else None,
            'description': data['description'] if 'description' in data else None,
        })
    else:
        return None

def parse_Links(data):
    if data:
        return CI("github.Links", {
            'self': parse_Link(data['self'] if 'self' in data else None),
            'review_comments': parse_Link(data['review_comments'] if 'review_comments' in data else None),
            'commits': parse_Link(data['commits'] if 'commits' in data else None),
            'statuses': parse_Link(data['statuses'] if 'statuses' in data else None),
            'issue': parse_Link(data['issue'] if 'issue' in data else None),
            'html': parse_Link(data['html'] if 'html' in data else None),
            'review_comment': parse_Link(data['review_comment'] if 'review_comment' in data else None),
            'comments': parse_Link(data['comments'] if 'comments' in data else None)
        })
    else:
        return None

def parse_Link(data):
    if data:
        return CI("github.Link", {
            'href': data['href'] if 'href' in data else None
        })
    else:
        return None

def parse_User(data):
    if data:
        return CI("github.User", {
            '_type': data['type'] if 'type' in data else None,
            'gists_url': data['gists_url'] if 'gists_url' in data else None,
            'organizations_url': data['organizations_url'] if 'organizations_url' in data else None,
            'gravatar_id': data['gravatar_id'] if 'gravatar_id' in data else None,
            'url': data['url'] if 'url' in data else None,
            '_id': data['id'] if 'id' in data else None,
            'node_id': data['node_id'] if 'node_id' in data else None,
            'repos_url': data['repos_url'] if 'repos_url' in data else None,
            'received_events_url': data['received_events_url'] if 'received_events_url' in data else None,
            'following_url': data['following_url'] if 'following_url' in data else None,
            'site_admin': data['site_admin'] if 'site_admin' in data else None,
            'subscriptions_url': data['subscriptions_url'] if 'subscriptions_url' in data else None,
            'starred_url': data['starred_url'] if 'starred_url' in data else None,
            'html_url': data['html_url'] if 'html_url' in data else None,
            'login': data['login'] if 'login' in data else None,
            'events_url': data['events_url'] if 'events_url' in data else None,
            'avatar_url': data['avatar_url'] if 'avatar_url' in data else None,
            'followers_url': data['followers_url'] if 'followers_url' in data else None
        })
    else:
        return None

def parse_Repository(data):
    if data:
        return CI("github.Repository", {
            'tags_url': data['tags_url'] if 'tags_url' in data else None,
            'statuses_url': data['statuses_url'] if 'statuses_url' in data else None,
            'has_downloads': data['has_downloads'] if 'has_downloads' in data else None,
            'blobs_url': data['blobs_url'] if 'blobs_url' in data else None,
            'git_refs_url': data['git_refs_url'] if 'git_refs_url' in data else None,
            'issue_events_url': data['issue_events_url'] if 'issue_events_url' in data else None,
            'has_issues': data['has_issues'] if 'has_issues' in data else None,
            'watchers_count': data['watchers_count'] if 'watchers_count' in data else None,
            'forks': data['forks'] if 'forks' in data else None,
            'private': data['private'] if 'private' in data else None,
            'size': data['size'] if 'size' in data else None,
            'open_issues_count': data['open_issues_count'] if 'open_issues_count' in data else None,
            'open_issues': data['open_issues'] if 'open_issues' in data else None,
            'subscribers_url': data['subscribers_url'] if 'subscribers_url' in data else None,
            'stargazers_count': data['stargazers_count'] if 'stargazers_count' in data else None,
            'url': data['url'] if 'url' in data else None,
            'full_name': data['full_name'] if 'full_name' in data else None,
            'releases_url': data['releases_url'] if 'releases_url' in data else None,
            'trees_url': data['trees_url'] if 'trees_url' in data else None,
            '_id': data['id'] if 'id' in data else None,
            'archived': data['archived'] if 'archived' in data else None,
            'branches_url': data['branches_url'] if 'branches_url' in data else None,
            'node_id': data['node_id'] if 'node_id' in data else None,
            'pushed_at': parseDate(data['pushed_at'] if 'pushed_at' in data else None),
            'git_url': data['git_url'] if 'git_url' in data else None,
            'collaborators_url': data['collaborators_url'] if 'collaborators_url' in data else None,
            'subscription_url': data['subscription_url'] if 'subscription_url' in data else None,
            'languages_url': data['languages_url'] if 'languages_url' in data else None,
            'has_wiki': data['has_wiki'] if 'has_wiki' in data else None,
            'commits_url': data['commits_url'] if 'commits_url' in data else None,
            'contents_url': data['contents_url'] if 'contents_url' in data else None,
            'fork': data['fork'] if 'fork' in data else None,
            'git_tags_url': data['git_tags_url'] if 'git_tags_url' in data else None,
            'downloads_url': data['downloads_url'] if 'downloads_url' in data else None,
            'svn_url': data['svn_url'] if 'svn_url' in data else None,
            'milestones_url': data['milestones_url'] if 'milestones_url' in data else None,
            'compare_url': data['compare_url'] if 'compare_url' in data else None,
            'notifications_url': data['notifications_url'] if 'notifications_url' in data else None,
            'comments_url': data['comments_url'] if 'comments_url' in data else None,
            'pulls_url': data['pulls_url'] if 'pulls_url' in data else None,
            'has_projects': data['has_projects'] if 'has_projects' in data else None,
            'teams_url': data['teams_url'] if 'teams_url' in data else None,
            'forks_count': data['forks_count'] if 'forks_count' in data else None,
            'merges_url': data['merges_url'] if 'merges_url' in data else None,
            'keys_url': data['keys_url'] if 'keys_url' in data else None,
            'deployments_url': data['deployments_url'] if 'deployments_url' in data else None,
            'contributors_url': data['contributors_url'] if 'contributors_url' in data else None,
            'forks_url': data['forks_url'] if 'forks_url' in data else None,
            'clone_url': data['clone_url'] if 'clone_url' in data else None,
            'created_at': parseDate(data['created_at'] if 'created_at' in data else None),
            'disabled': data['disabled'] if 'disabled' in data else None,
            'hooks_url': data['hooks_url'] if 'hooks_url' in data else None,
            '_name': data['name'] if 'name' in data else None,
            'ssh_url': data['ssh_url'] if 'ssh_url' in data else None,
            'owner': parse_User(data['owner'] if 'owner' in data else None),
            'html_url': data['html_url'] if 'html_url' in data else None,
            'archive_url': data['archive_url'] if 'archive_url' in data else None,
            'default_branch': data['default_branch'] if 'default_branch' in data else None,
            'updated_at': parseDate(data['updated_at'] if 'updated_at' in data else None),
            'issues_url': data['issues_url'] if 'issues_url' in data else None,
            'assignees_url': data['assignees_url'] if 'assignees_url' in data else None,
            'events_url': data['events_url'] if 'events_url' in data else None,
            'watchers': data['watchers'] if 'watchers' in data else None,
            'issue_comment_url': data['issue_comment_url'] if 'issue_comment_url' in data else None,
            'labels_url': data['labels_url'] if 'labels_url' in data else None,
            'has_pages': data['has_pages'] if 'has_pages' in data else None,
            'git_commits_url': data['git_commits_url'] if 'git_commits_url' in data else None,
            'stargazers_url': data['stargazers_url'] if 'stargazers_url' in data else None
        })
    else:
        return None


def parse_PullRequestEvent(data):
    if data:
        return CI("github.PullRequestEvent", {
            'number': data['number'] if 'number' in data else None,
            'repository': parse_Repository(data['repository'] if 'repository' in data else None),
            'sender': parse_User(data['sender'] if 'sender' in data else None),
            'action': data['action'] if 'action' in data else None,
            'pull_request': parse_PullRequest(data['pull_request'] if 'pull_request' in data else None)
        })
    else:
        return None

output = parse_PullRequestEvent(json.loads(input.content))

def filter_satisfied(ci):
    action_filter = config.actionFilter
    repository_name_filter = config.repositoryNameFilter
    base_branch_filter = config.baseBranchFilter
    head_branch_filter = config.headBranchFilter

    repository_name = ci.repository._name if ci.repository else None
    head_branch_name = ci.pull_request.head.ref if (ci.pull_request is not None and ci.pull_request.head is not None) else None
    base_branch_name = ci.pull_request.base.ref if (ci.pull_request is not None and ci.pull_request.base is not None) else None

    action_condition = not action_filter or action_filter == ci.action
    repo_condition = not repository_name_filter or repository_name_filter == repository_name
    head_branch_condition = not head_branch_filter or head_branch_filter == head_branch_name
    base_branch_condition = not base_branch_filter or base_branch_filter == base_branch_name

    return action_condition and repo_condition and head_branch_condition and base_branch_condition

if not filter_satisfied(output):
    output = None
