# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.


import json
from gitlab.Client import Client

client = Client()
commits = []
if gitlab_server is None or project_id is None or results_limit is None:
    commits = []
else:
    commits = json.loads(client.gitlab_querycommits(locals())["commits"])

authors = {}
committers = {}
people = []
for commit in commits:
    if commit["author_name"] in authors.keys():
        authors[commit["author_name"]] += 1
    else:
        authors[commit["author_name"]] = 1
    if commit["author_name"] not in people:
        people.append(commit["author_name"])

    if commit["committer_name"] in committers.keys():
        committers[commit["committer_name"]] += 1
    else:
        committers[commit["committer_name"]] = 1
    if commit["committer_name"] not in people:
        people.append(commit["committer_name"])

data = {
    "commits": commits,
    "authors": [
        {"name": author, "value": authors[author]} for author in authors.keys()
    ],
    "committers": [
        {"name": committer, "value": committers[committer]}
        for committer in committers.keys()
    ],
    "people": people,
}
