# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.

from gitlab.Client import Client
import sys

client = Client()

response = client.gitlab_pipeline_status(locals())
if response is not None:
    for key, value in response.items():
        locals()[key] = value

task.setStatusLine(
    "Pipeline #{0}: {1}".format(response["pipeline_id"], response["status"])
)
pipeline_status = response["status"]
pipeline_web_url = response["web_url"]

if response["status"] == "failed" or response["status"] == "canceled":
    pipeline_status = response["status"]
    raise Exception("Pipeline #{0}: {1}".format(response["pipeline_id"], response["status"]))
elif response["status"] == "success":
    print "Pipeline #{0}: {1}".format(response["pipeline_id"], "Success!")
    pipeline_status = response["status"]
else:
    task.schedule("gitlab/create-pipeline-wait.py")
